/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Communicates with OData 4.0 services using Apache Olingo OData API.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Olingo4EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Olingo4 component.
     */
    public interface Olingo4EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOlingo4EndpointConsumerBuilder advanced() {
            return (AdvancedOlingo4EndpointConsumerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder connectTimeout(
                String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Olingo4EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Olingo4EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Olingo4 component.
     */
    public interface AdvancedOlingo4EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Olingo4EndpointConsumerBuilder basic() {
            return (Olingo4EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo4EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo4EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo4EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo4EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Olingo4 component.
     */
    public interface Olingo4EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOlingo4EndpointProducerBuilder advanced() {
            return (AdvancedOlingo4EndpointProducerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Olingo4EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Olingo4EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Olingo4 component.
     */
    public interface AdvancedOlingo4EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Olingo4EndpointProducerBuilder basic() {
            return (Olingo4EndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Olingo4 component.
     */
    public interface Olingo4EndpointBuilder
            extends
                Olingo4EndpointConsumerBuilder, Olingo4EndpointProducerBuilder {
        default AdvancedOlingo4EndpointBuilder advanced() {
            return (AdvancedOlingo4EndpointBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder connectTimeout(String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder socketTimeout(String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo4EndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Olingo4 component.
     */
    public interface AdvancedOlingo4EndpointBuilder
            extends
                AdvancedOlingo4EndpointConsumerBuilder, AdvancedOlingo4EndpointProducerBuilder {
        default Olingo4EndpointBuilder basic() {
            return (Olingo4EndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo4EndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicates with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Available as of version: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     * 
     * Syntax: <code>olingo4:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     */
    default Olingo4EndpointBuilder olingo4(String path) {
        class Olingo4EndpointBuilderImpl extends AbstractEndpointBuilder implements Olingo4EndpointBuilder, AdvancedOlingo4EndpointBuilder {
            public Olingo4EndpointBuilderImpl(String path) {
                super("olingo4", path);
            }
        }
        return new Olingo4EndpointBuilderImpl(path);
    }
}