/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Communicates with OData 2.0 services using Apache Olingo.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Olingo2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Olingo2 component.
     */
    public interface Olingo2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOlingo2EndpointConsumerBuilder advanced() {
            return (AdvancedOlingo2EndpointConsumerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder connectTimeout(
                String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Olingo2EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Olingo2EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Olingo2EndpointConsumerBuilder basic() {
            return (Olingo2EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo2EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo2EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOlingo2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Olingo2 component.
     */
    public interface Olingo2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOlingo2EndpointProducerBuilder advanced() {
            return (AdvancedOlingo2EndpointProducerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Olingo2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Olingo2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Olingo2EndpointProducerBuilder basic() {
            return (Olingo2EndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Olingo2 component.
     */
    public interface Olingo2EndpointBuilder
            extends
                Olingo2EndpointConsumerBuilder, Olingo2EndpointProducerBuilder {
        default AdvancedOlingo2EndpointBuilder advanced() {
            return (AdvancedOlingo2EndpointBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder connectTimeout(String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            setProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpAsyncClientBuilder(
                Object httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.nio.client.HttpAsyncClientBuilder</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            setProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpClientBuilder(
                Object httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.client.HttpClientBuilder</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpClientBuilder(
                String httpClientBuilder) {
            setProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpHeaders(
                Map<String, String> httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder httpHeaders(String httpHeaders) {
            setProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder proxy(Object proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.HttpHost</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder proxy(String proxy) {
            setProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder serviceUri(String serviceUri) {
            setProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder socketTimeout(String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: common
         */
        default Olingo2EndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointBuilder
            extends
                AdvancedOlingo2EndpointConsumerBuilder, AdvancedOlingo2EndpointProducerBuilder {
        default Olingo2EndpointBuilder basic() {
            return (Olingo2EndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedOlingo2EndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicates with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Available as of version: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     * 
     * Syntax: <code>olingo2:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     */
    default Olingo2EndpointBuilder olingo2(String path) {
        class Olingo2EndpointBuilderImpl extends AbstractEndpointBuilder implements Olingo2EndpointBuilder, AdvancedOlingo2EndpointBuilder {
            public Olingo2EndpointBuilderImpl(String path) {
                super("olingo2", path);
            }
        }
        return new Olingo2EndpointBuilderImpl(path);
    }
}