/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Socket level networking using TCP or UDP with the Apache Mina 2.x library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Mina2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Mina2 component.
     */
    public interface Mina2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMina2EndpointConsumerBuilder advanced() {
            return (AdvancedMina2EndpointConsumerBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder disconnect(boolean disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder disconnect(String disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder minaLogger(boolean minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder minaLogger(String minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder sync(boolean sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder sync(String sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder timeout(long timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder timeout(String timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder writeTimeout(long writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointConsumerBuilder writeTimeout(String writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Mina2EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Mina2EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the clientMode is true, mina consumer will connect the address as
         * a TCP client.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Mina2EndpointConsumerBuilder clientMode(boolean clientMode) {
            setProperty("clientMode", clientMode);
            return this;
        }
        /**
         * If the clientMode is true, mina consumer will connect the address as
         * a TCP client.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Mina2EndpointConsumerBuilder clientMode(String clientMode) {
            setProperty("clientMode", clientMode);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder codec(Object codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder codec(String codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder filters(List<Object> filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder filters(String filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder textline(boolean textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder textline(String textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder textlineDelimiter(
                Mina2TextLineDelimiter textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointConsumerBuilder textlineDelimiter(
                String textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointConsumerBuilder autoStartTls(boolean autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointConsumerBuilder autoStartTls(String autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Mina2 component.
     */
    public interface AdvancedMina2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Mina2EndpointConsumerBuilder basic() {
            return (Mina2EndpointConsumerBuilder) this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            setProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            setProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * If sync is enabled this option dictates MinaConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder noReplyLogLevel(
                LoggingLevel noReplyLogLevel) {
            setProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If sync is enabled this option dictates MinaConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMina2EndpointConsumerBuilder noReplyLogLevel(
                String noReplyLogLevel) {
            setProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder maximumPoolSize(
                int maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder maximumPoolSize(
                String maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder transferExchange(
                boolean transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointConsumerBuilder transferExchange(
                String transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Mina2 component.
     */
    public interface Mina2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMina2EndpointProducerBuilder advanced() {
            return (AdvancedMina2EndpointProducerBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder disconnect(boolean disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder disconnect(String disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder minaLogger(boolean minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder minaLogger(String minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder sync(boolean sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder sync(String sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder timeout(long timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder timeout(String timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder writeTimeout(long writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointProducerBuilder writeTimeout(String writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Mina2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Mina2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder codec(Object codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder codec(String codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder filters(List<Object> filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder filters(String filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder textline(boolean textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder textline(String textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder textlineDelimiter(
                Mina2TextLineDelimiter textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointProducerBuilder textlineDelimiter(
                String textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointProducerBuilder autoStartTls(boolean autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointProducerBuilder autoStartTls(String autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Mina2 component.
     */
    public interface AdvancedMina2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Mina2EndpointProducerBuilder basic() {
            return (Mina2EndpointProducerBuilder) this;
        }
        /**
         * Whether to create the InetAddress once and reuse. Setting this to
         * false allows to pickup DNS changes in the network.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMina2EndpointProducerBuilder cachedAddress(
                boolean cachedAddress) {
            setProperty("cachedAddress", cachedAddress);
            return this;
        }
        /**
         * Whether to create the InetAddress once and reuse. Setting this to
         * false allows to pickup DNS changes in the network.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMina2EndpointProducerBuilder cachedAddress(
                String cachedAddress) {
            setProperty("cachedAddress", cachedAddress);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMina2EndpointProducerBuilder lazySessionCreation(
                boolean lazySessionCreation) {
            setProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMina2EndpointProducerBuilder lazySessionCreation(
                String lazySessionCreation) {
            setProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder maximumPoolSize(
                int maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder maximumPoolSize(
                String maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder transferExchange(
                boolean transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointProducerBuilder transferExchange(
                String transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Mina2 component.
     */
    public interface Mina2EndpointBuilder
            extends
                Mina2EndpointConsumerBuilder, Mina2EndpointProducerBuilder {
        default AdvancedMina2EndpointBuilder advanced() {
            return (AdvancedMina2EndpointBuilder) this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder disconnect(boolean disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Mina session right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder disconnect(String disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder minaLogger(boolean minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder minaLogger(String minaLogger) {
            setProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder sync(boolean sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder sync(String sync) {
            setProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder timeout(long timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder timeout(String timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder writeTimeout(long writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default Mina2EndpointBuilder writeTimeout(String writeTimeout) {
            setProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder allowDefaultCodec(String allowDefaultCodec) {
            setProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder codec(Object codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * <code>org.apache.mina.filter.codec.ProtocolCodecFactory</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder codec(String codec) {
            setProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            setProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            setProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder filters(List<Object> filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.mina.core.filterchain.IoFilter&gt;</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder filters(String filters) {
            setProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder textline(boolean textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder textline(String textline) {
            setProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder textlineDelimiter(
                Mina2TextLineDelimiter textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
         * type.
         * 
         * Group: codec
         */
        default Mina2EndpointBuilder textlineDelimiter(String textlineDelimiter) {
            setProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointBuilder autoStartTls(boolean autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * Whether to auto start SSL handshake.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointBuilder autoStartTls(String autoStartTls) {
            setProperty("autoStartTls", autoStartTls);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default Mina2EndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Mina2 component.
     */
    public interface AdvancedMina2EndpointBuilder
            extends
                AdvancedMina2EndpointConsumerBuilder, AdvancedMina2EndpointProducerBuilder {
        default Mina2EndpointBuilder basic() {
            return (Mina2EndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder maximumPoolSize(int maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder maximumPoolSize(
                String maximumPoolSize) {
            setProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            setProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder transferExchange(
                boolean transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMina2EndpointBuilder transferExchange(
                String transferExchange) {
            setProperty("transferExchange", transferExchange);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.mina2.Mina2TextLineDelimiter</code>
     * enum.
     */
    enum Mina2TextLineDelimiter {
        DEFAULT,
        AUTO,
        UNIX,
        WINDOWS,
        MAC;
    }
    /**
     * Mina2 (camel-mina2)
     * Socket level networking using TCP or UDP with the Apache Mina 2.x
     * library.
     * 
     * Category: networking,tcp,udp
     * Available as of version: 2.10
     * Maven coordinates: org.apache.camel:camel-mina2
     * 
     * Syntax: <code>mina:protocol:host:port</code>
     * 
     * Path parameter: protocol (required)
     * Protocol to use
     * 
     * Path parameter: host (required)
     * Hostname to use. Use localhost or 0.0.0.0 for local server as consumer.
     * For producer use the hostname or ip address of the remote server.
     * 
     * Path parameter: port (required)
     * Port number
     */
    default Mina2EndpointBuilder mina2(String path) {
        class Mina2EndpointBuilderImpl extends AbstractEndpointBuilder implements Mina2EndpointBuilder, AdvancedMina2EndpointBuilder {
            public Mina2EndpointBuilderImpl(String path) {
                super("mina", path);
            }
        }
        return new Mina2EndpointBuilderImpl(path);
    }
}