/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.net.URL;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Connect to OPC UA servers using the binary protocol for acquiring telemetry
 * data
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MiloClientEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the OPC UA Client component.
     */
    public interface MiloClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMiloClientEndpointConsumerBuilder advanced() {
            return (AdvancedMiloClientEndpointConsumerBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            setProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            setProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder method(Object method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder method(String method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder node(Object node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder node(String node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder samplingInterval(
                Double samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointConsumerBuilder samplingInterval(
                String samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MiloClientEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MiloClientEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a: <code>java.util.Set&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * <code>java.util.Set&lt;java.lang.String&gt;</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder applicationName(
                String applicationName) {
            setProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder applicationUri(
                String applicationUri) {
            setProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder channelLifetime(
                Long channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder channelLifetime(
                String channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyAlias(String keyAlias) {
            setProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyPassword(String keyPassword) {
            setProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyStorePassword(
                String keyStorePassword) {
            setProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyStoreType(
                String keyStoreType) {
            setProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyStoreUrl(URL keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder keyStoreUrl(String keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder overrideHost(
                boolean overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder overrideHost(
                String overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder productUri(String productUri) {
            setProperty("productUri", productUri);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder requestTimeout(
                Long requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder sessionName(String sessionName) {
            setProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder sessionTimeout(
                Long sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointConsumerBuilder sessionTimeout(
                String sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MiloClientEndpointConsumerBuilder basic() {
            return (MiloClientEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMiloClientEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMiloClientEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMiloClientEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMiloClientEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the OPC UA Client component.
     */
    public interface MiloClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMiloClientEndpointProducerBuilder advanced() {
            return (AdvancedMiloClientEndpointProducerBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            setProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            setProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder method(Object method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder method(String method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder node(Object node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder node(String node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder samplingInterval(
                Double samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointProducerBuilder samplingInterval(
                String samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MiloClientEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MiloClientEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a: <code>java.util.Set&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * <code>java.util.Set&lt;java.lang.String&gt;</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder applicationName(
                String applicationName) {
            setProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder applicationUri(
                String applicationUri) {
            setProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder channelLifetime(
                Long channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder channelLifetime(
                String channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyAlias(String keyAlias) {
            setProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyPassword(String keyPassword) {
            setProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyStorePassword(
                String keyStorePassword) {
            setProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyStoreType(
                String keyStoreType) {
            setProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyStoreUrl(URL keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder keyStoreUrl(String keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder overrideHost(
                boolean overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder overrideHost(
                String overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder productUri(String productUri) {
            setProperty("productUri", productUri);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder requestTimeout(
                Long requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder sessionName(String sessionName) {
            setProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder sessionTimeout(
                Long sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointProducerBuilder sessionTimeout(
                String sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MiloClientEndpointProducerBuilder basic() {
            return (MiloClientEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the OPC UA Client component.
     */
    public interface MiloClientEndpointBuilder
            extends
                MiloClientEndpointConsumerBuilder, MiloClientEndpointProducerBuilder {
        default AdvancedMiloClientEndpointBuilder advanced() {
            return (AdvancedMiloClientEndpointBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            setProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            setProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            setProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder method(Object method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder method(String method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a:
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder node(Object node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option will be converted to a
         * <code>org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder node(String node) {
            setProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder samplingInterval(
                Double samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: common
         */
        default MiloClientEndpointBuilder samplingInterval(
                String samplingInterval) {
            setProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a: <code>java.util.Set&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * <code>java.util.Set&lt;java.lang.String&gt;</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            setProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder applicationName(String applicationName) {
            setProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder applicationUri(String applicationUri) {
            setProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder channelLifetime(Long channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder channelLifetime(String channelLifetime) {
            setProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyAlias(String keyAlias) {
            setProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyPassword(String keyPassword) {
            setProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyStorePassword(
                String keyStorePassword) {
            setProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyStoreType(String keyStoreType) {
            setProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyStoreUrl(URL keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder keyStoreUrl(String keyStoreUrl) {
            setProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            setProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            setProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder overrideHost(boolean overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder overrideHost(String overrideHost) {
            setProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder productUri(String productUri) {
            setProperty("productUri", productUri);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder requestTimeout(Long requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder requestTimeout(String requestTimeout) {
            setProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder sessionName(String sessionName) {
            setProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder sessionTimeout(Long sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: client
         */
        default MiloClientEndpointBuilder sessionTimeout(String sessionTimeout) {
            setProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointBuilder
            extends
                AdvancedMiloClientEndpointConsumerBuilder, AdvancedMiloClientEndpointProducerBuilder {
        default MiloClientEndpointBuilder basic() {
            return (MiloClientEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMiloClientEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * OPC UA Client (camel-milo)
     * Connect to OPC UA servers using the binary protocol for acquiring
     * telemetry data
     * 
     * Category: iot
     * Available as of version: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-client:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The OPC UA server endpoint
     */
    default MiloClientEndpointBuilder miloClient(String path) {
        class MiloClientEndpointBuilderImpl extends AbstractEndpointBuilder implements MiloClientEndpointBuilder, AdvancedMiloClientEndpointBuilder {
            public MiloClientEndpointBuilderImpl(String path) {
                super("milo-client", path);
            }
        }
        return new MiloClientEndpointBuilderImpl(path);
    }
}