/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The log component logs message exchanges to the underlying logging mechanism.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface LogEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Log component.
     */
    public interface LogEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedLogEndpointBuilder advanced() {
            return (AdvancedLogEndpointBuilder) this;
        }
        /**
         * If true, will hide stats when no new messages have been received for
         * a time interval, if false, show stats regardless of message traffic.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupActiveOnly(Boolean groupActiveOnly) {
            setProperty("groupActiveOnly", groupActiveOnly);
            return this;
        }
        /**
         * If true, will hide stats when no new messages have been received for
         * a time interval, if false, show stats regardless of message traffic.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupActiveOnly(String groupActiveOnly) {
            setProperty("groupActiveOnly", groupActiveOnly);
            return this;
        }
        /**
         * Set the initial delay for stats (in millis).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupDelay(Long groupDelay) {
            setProperty("groupDelay", groupDelay);
            return this;
        }
        /**
         * Set the initial delay for stats (in millis).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupDelay(String groupDelay) {
            setProperty("groupDelay", groupDelay);
            return this;
        }
        /**
         * If specified will group message stats by this time interval (in
         * millis).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupInterval(Long groupInterval) {
            setProperty("groupInterval", groupInterval);
            return this;
        }
        /**
         * If specified will group message stats by this time interval (in
         * millis).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupInterval(String groupInterval) {
            setProperty("groupInterval", groupInterval);
            return this;
        }
        /**
         * An integer that specifies a group size for throughput logging.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupSize(Integer groupSize) {
            setProperty("groupSize", groupSize);
            return this;
        }
        /**
         * An integer that specifies a group size for throughput logging.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder groupSize(String groupSize) {
            setProperty("groupSize", groupSize);
            return this;
        }
        /**
         * Logging level to use. The default value is INFO.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder level(String level) {
            setProperty("level", level);
            return this;
        }
        /**
         * If true, mask sensitive information like password or passphrase in
         * the log.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder logMask(Boolean logMask) {
            setProperty("logMask", logMask);
            return this;
        }
        /**
         * If true, mask sensitive information like password or passphrase in
         * the log.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder logMask(String logMask) {
            setProperty("logMask", logMask);
            return this;
        }
        /**
         * An optional Marker name to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default LogEndpointBuilder marker(String marker) {
            setProperty("marker", marker);
            return this;
        }
        /**
         * Limits the number of characters logged per line.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder maxChars(int maxChars) {
            setProperty("maxChars", maxChars);
            return this;
        }
        /**
         * Limits the number of characters logged per line.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder maxChars(String maxChars) {
            setProperty("maxChars", maxChars);
            return this;
        }
        /**
         * If enabled then each information is outputted on a newline.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder multiline(boolean multiline) {
            setProperty("multiline", multiline);
            return this;
        }
        /**
         * If enabled then each information is outputted on a newline.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder multiline(String multiline) {
            setProperty("multiline", multiline);
            return this;
        }
        /**
         * Quick option for turning all options on. (multiline, maxChars has to
         * be manually set if to be used).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showAll(boolean showAll) {
            setProperty("showAll", showAll);
            return this;
        }
        /**
         * Quick option for turning all options on. (multiline, maxChars has to
         * be manually set if to be used).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showAll(String showAll) {
            setProperty("showAll", showAll);
            return this;
        }
        /**
         * Show the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showBody(boolean showBody) {
            setProperty("showBody", showBody);
            return this;
        }
        /**
         * Show the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showBody(String showBody) {
            setProperty("showBody", showBody);
            return this;
        }
        /**
         * Show the body Java type.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showBodyType(boolean showBodyType) {
            setProperty("showBodyType", showBodyType);
            return this;
        }
        /**
         * Show the body Java type.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showBodyType(String showBodyType) {
            setProperty("showBodyType", showBodyType);
            return this;
        }
        /**
         * f the exchange has a caught exception, show the exception message (no
         * stack trace).A caught exception is stored as a property on the
         * exchange (using the key org.apache.camel.Exchange#EXCEPTION_CAUGHT
         * and for instance a doCatch can catch exceptions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showCaughtException(
                boolean showCaughtException) {
            setProperty("showCaughtException", showCaughtException);
            return this;
        }
        /**
         * f the exchange has a caught exception, show the exception message (no
         * stack trace).A caught exception is stored as a property on the
         * exchange (using the key org.apache.camel.Exchange#EXCEPTION_CAUGHT
         * and for instance a doCatch can catch exceptions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showCaughtException(
                String showCaughtException) {
            setProperty("showCaughtException", showCaughtException);
            return this;
        }
        /**
         * If the exchange has an exception, show the exception message (no
         * stacktrace).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showException(boolean showException) {
            setProperty("showException", showException);
            return this;
        }
        /**
         * If the exchange has an exception, show the exception message (no
         * stacktrace).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showException(String showException) {
            setProperty("showException", showException);
            return this;
        }
        /**
         * Show the unique exchange ID.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showExchangeId(boolean showExchangeId) {
            setProperty("showExchangeId", showExchangeId);
            return this;
        }
        /**
         * Show the unique exchange ID.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showExchangeId(String showExchangeId) {
            setProperty("showExchangeId", showExchangeId);
            return this;
        }
        /**
         * Shows the Message Exchange Pattern (or MEP for short).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showExchangePattern(
                boolean showExchangePattern) {
            setProperty("showExchangePattern", showExchangePattern);
            return this;
        }
        /**
         * Shows the Message Exchange Pattern (or MEP for short).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showExchangePattern(
                String showExchangePattern) {
            setProperty("showExchangePattern", showExchangePattern);
            return this;
        }
        /**
         * If enabled Camel will output files.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showFiles(boolean showFiles) {
            setProperty("showFiles", showFiles);
            return this;
        }
        /**
         * If enabled Camel will output files.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showFiles(String showFiles) {
            setProperty("showFiles", showFiles);
            return this;
        }
        /**
         * If enabled Camel will on Future objects wait for it to complete to
         * obtain the payload to be logged.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showFuture(boolean showFuture) {
            setProperty("showFuture", showFuture);
            return this;
        }
        /**
         * If enabled Camel will on Future objects wait for it to complete to
         * obtain the payload to be logged.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showFuture(String showFuture) {
            setProperty("showFuture", showFuture);
            return this;
        }
        /**
         * Show the message headers.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showHeaders(boolean showHeaders) {
            setProperty("showHeaders", showHeaders);
            return this;
        }
        /**
         * Show the message headers.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showHeaders(String showHeaders) {
            setProperty("showHeaders", showHeaders);
            return this;
        }
        /**
         * If the exchange has an out message, show the out message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showOut(boolean showOut) {
            setProperty("showOut", showOut);
            return this;
        }
        /**
         * If the exchange has an out message, show the out message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showOut(String showOut) {
            setProperty("showOut", showOut);
            return this;
        }
        /**
         * Show the exchange properties.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showProperties(boolean showProperties) {
            setProperty("showProperties", showProperties);
            return this;
        }
        /**
         * Show the exchange properties.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showProperties(String showProperties) {
            setProperty("showProperties", showProperties);
            return this;
        }
        /**
         * Show the stack trace, if an exchange has an exception. Only effective
         * if one of showAll, showException or showCaughtException are enabled.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showStackTrace(boolean showStackTrace) {
            setProperty("showStackTrace", showStackTrace);
            return this;
        }
        /**
         * Show the stack trace, if an exchange has an exception. Only effective
         * if one of showAll, showException or showCaughtException are enabled.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showStackTrace(String showStackTrace) {
            setProperty("showStackTrace", showStackTrace);
            return this;
        }
        /**
         * Whether Camel should show stream bodies or not (eg such as
         * java.io.InputStream). Beware if you enable this option then you may
         * not be able later to access the message body as the stream have
         * already been read by this logger. To remedy this you will have to use
         * Stream Caching.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showStreams(boolean showStreams) {
            setProperty("showStreams", showStreams);
            return this;
        }
        /**
         * Whether Camel should show stream bodies or not (eg such as
         * java.io.InputStream). Beware if you enable this option then you may
         * not be able later to access the message body as the stream have
         * already been read by this logger. To remedy this you will have to use
         * Stream Caching.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder showStreams(String showStreams) {
            setProperty("showStreams", showStreams);
            return this;
        }
        /**
         * Whether to skip line separators when logging the message body.This
         * allows to log the message body in one line, setting this option to
         * false will preserve any line separators from the body, which then
         * will log the body as is.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder skipBodyLineSeparator(
                boolean skipBodyLineSeparator) {
            setProperty("skipBodyLineSeparator", skipBodyLineSeparator);
            return this;
        }
        /**
         * Whether to skip line separators when logging the message body.This
         * allows to log the message body in one line, setting this option to
         * false will preserve any line separators from the body, which then
         * will log the body as is.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder skipBodyLineSeparator(
                String skipBodyLineSeparator) {
            setProperty("skipBodyLineSeparator", skipBodyLineSeparator);
            return this;
        }
        /**
         * Sets the outputs style to use.
         * 
         * The option is a:
         * <code>org.apache.camel.support.processor.DefaultExchangeFormatter$OutputStyle</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder style(OutputStyle style) {
            setProperty("style", style);
            return this;
        }
        /**
         * Sets the outputs style to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.processor.DefaultExchangeFormatter$OutputStyle</code> type.
         * 
         * Group: formatting
         */
        default LogEndpointBuilder style(String style) {
            setProperty("style", style);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Log component.
     */
    public interface AdvancedLogEndpointBuilder
            extends
                EndpointProducerBuilder {
        default LogEndpointBuilder basic() {
            return (LogEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLogEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLogEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLogEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLogEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.support.processor.DefaultExchangeFormatter$OutputStyle</code> enum.
     */
    enum OutputStyle {
        Default,
        Tab,
        Fixed;
    }
    /**
     * Log (camel-log)
     * The log component logs message exchanges to the underlying logging
     * mechanism.
     * 
     * Category: core,monitoring
     * Available as of version: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     * 
     * Syntax: <code>log:loggerName</code>
     * 
     * Path parameter: loggerName (required)
     * The logger name to use
     */
    default LogEndpointBuilder log(String path) {
        class LogEndpointBuilderImpl extends AbstractEndpointBuilder implements LogEndpointBuilder, AdvancedLogEndpointBuilder {
            public LogEndpointBuilderImpl(String path) {
                super("log", path);
            }
        }
        return new LogEndpointBuilderImpl(path);
    }
}