/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The linkedin component is used for retrieving LinkedIn user profiles,
 * connections, companies, groups, posts, etc.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface LinkedInEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Linkedin component.
     */
    public interface LinkedInEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedLinkedInEndpointConsumerBuilder advanced() {
            return (AdvancedLinkedInEndpointConsumerBuilder) this;
        }
        /**
         * LinkedIn access token to avoid username and password login procedure.
         * LinkedIn responds to login forms by using a CAPTCHA. This makes it
         * impossible for a standalone, headless process to log in to LinkedIn
         * by specifying a username and password. To work around this, obtain a
         * LinkedIn access token and provide the token as the setting of the
         * accessToken parameter. Obtaining a LinkedIn access token is a
         * multi-step procedure. You must configure your LinkedIn application,
         * obtain a LinkedIn authorization code, and exchange that code for the
         * LinkedIn access token. For details, see:
         * https://developer.linkedin.com/docs/oauth2 The default behavior is
         * that the access token expires after 60 days. To change this, specify
         * a value for the expiryTime paramter. If the access token expires, the
         * LinkedIn component tries to log in to LinkedIn by providing a
         * username and password, which results in a CAPTCHA so the login fails.
         * The LinkedIn component cannot refresh the access token. You must
         * manually obtain a new access token each time an access token expires.
         * When you update the access token you must restart the application so
         * that it uses the new token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * LinkedIn application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * LinkedIn application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder expiryTime(Long expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder expiryTime(String expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder lazyAuth(boolean lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder lazyAuth(String lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Application redirect URI, although the component never redirects to
         * this page to avoid having to have a functioning redirect server. For
         * testing, one could use https://localhost.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder redirectUri(String redirectUri) {
            setProperty("redirectUri", redirectUri);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder scopes(OAuthScope[] scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder scopes(String scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder secureStorage(
                Object secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder secureStorage(
                String secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * LinkedIn user account name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * LinkedIn account password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointConsumerBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default LinkedInEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default LinkedInEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Linkedin component.
     */
    public interface AdvancedLinkedInEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default LinkedInEndpointConsumerBuilder basic() {
            return (LinkedInEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedLinkedInEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedLinkedInEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedLinkedInEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedLinkedInEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Linkedin component.
     */
    public interface LinkedInEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedLinkedInEndpointProducerBuilder advanced() {
            return (AdvancedLinkedInEndpointProducerBuilder) this;
        }
        /**
         * LinkedIn access token to avoid username and password login procedure.
         * LinkedIn responds to login forms by using a CAPTCHA. This makes it
         * impossible for a standalone, headless process to log in to LinkedIn
         * by specifying a username and password. To work around this, obtain a
         * LinkedIn access token and provide the token as the setting of the
         * accessToken parameter. Obtaining a LinkedIn access token is a
         * multi-step procedure. You must configure your LinkedIn application,
         * obtain a LinkedIn authorization code, and exchange that code for the
         * LinkedIn access token. For details, see:
         * https://developer.linkedin.com/docs/oauth2 The default behavior is
         * that the access token expires after 60 days. To change this, specify
         * a value for the expiryTime paramter. If the access token expires, the
         * LinkedIn component tries to log in to LinkedIn by providing a
         * username and password, which results in a CAPTCHA so the login fails.
         * The LinkedIn component cannot refresh the access token. You must
         * manually obtain a new access token each time an access token expires.
         * When you update the access token you must restart the application so
         * that it uses the new token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * LinkedIn application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * LinkedIn application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder expiryTime(Long expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder expiryTime(String expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder lazyAuth(boolean lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder lazyAuth(String lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Application redirect URI, although the component never redirects to
         * this page to avoid having to have a functioning redirect server. For
         * testing, one could use https://localhost.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder redirectUri(String redirectUri) {
            setProperty("redirectUri", redirectUri);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder scopes(OAuthScope[] scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder scopes(String scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder secureStorage(
                Object secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder secureStorage(
                String secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * LinkedIn user account name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * LinkedIn account password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointProducerBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default LinkedInEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default LinkedInEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Linkedin component.
     */
    public interface AdvancedLinkedInEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default LinkedInEndpointProducerBuilder basic() {
            return (LinkedInEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Linkedin component.
     */
    public interface LinkedInEndpointBuilder
            extends
                LinkedInEndpointConsumerBuilder, LinkedInEndpointProducerBuilder {
        default AdvancedLinkedInEndpointBuilder advanced() {
            return (AdvancedLinkedInEndpointBuilder) this;
        }
        /**
         * LinkedIn access token to avoid username and password login procedure.
         * LinkedIn responds to login forms by using a CAPTCHA. This makes it
         * impossible for a standalone, headless process to log in to LinkedIn
         * by specifying a username and password. To work around this, obtain a
         * LinkedIn access token and provide the token as the setting of the
         * accessToken parameter. Obtaining a LinkedIn access token is a
         * multi-step procedure. You must configure your LinkedIn application,
         * obtain a LinkedIn authorization code, and exchange that code for the
         * LinkedIn access token. For details, see:
         * https://developer.linkedin.com/docs/oauth2 The default behavior is
         * that the access token expires after 60 days. To change this, specify
         * a value for the expiryTime paramter. If the access token expires, the
         * LinkedIn component tries to log in to LinkedIn by providing a
         * username and password, which results in a CAPTCHA so the login fails.
         * The LinkedIn component cannot refresh the access token. You must
         * manually obtain a new access token each time an access token expires.
         * When you update the access token you must restart the application so
         * that it uses the new token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * LinkedIn application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * LinkedIn application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder expiryTime(Long expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * A number of milliseconds since the UNIX Epoch. The default is 60
         * days. A LinkedIn access token expires when this amount of time
         * elapses after the token is in use.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder expiryTime(String expiryTime) {
            setProperty("expiryTime", expiryTime);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP parameters, for example, proxy host and port. Use
         * constants from AllClientPNames.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder lazyAuth(boolean lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Flag to enable/disable lazy OAuth, default is true. When enabled,
         * OAuth token retrieval or generation is not done until the first REST
         * call.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder lazyAuth(String lazyAuth) {
            setProperty("lazyAuth", lazyAuth);
            return this;
        }
        /**
         * Application redirect URI, although the component never redirects to
         * this page to avoid having to have a functioning redirect server. For
         * testing, one could use https://localhost.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder redirectUri(String redirectUri) {
            setProperty("redirectUri", redirectUri);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder scopes(OAuthScope[] scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * List of LinkedIn scopes as specified at
         * https://developer.linkedin.com/documents/authentication#granting.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthScope[]</code>
         * type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder scopes(String scopes) {
            setProperty("scopes", scopes);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option is a:
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder secureStorage(Object secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * Callback interface for providing an OAuth token or to store the token
         * generated by the component. The callback should return null on the
         * first call and then save the created token in the saveToken()
         * callback. If the callback returns null the first time, a userPassword
         * MUST be provided.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.linkedin.api.OAuthSecureStorage</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder secureStorage(String secureStorage) {
            setProperty("secureStorage", secureStorage);
            return this;
        }
        /**
         * LinkedIn user account name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * LinkedIn account password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default LinkedInEndpointBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Linkedin component.
     */
    public interface AdvancedLinkedInEndpointBuilder
            extends
                AdvancedLinkedInEndpointConsumerBuilder, AdvancedLinkedInEndpointProducerBuilder {
        default LinkedInEndpointBuilder basic() {
            return (LinkedInEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedLinkedInEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.linkedin.api.OAuthScope</code> enum.
     */
    enum OAuthScope {
        R_BASICPROFILE,
        R_FULLPROFILE,
        R_EMAILADDRESS,
        R_NETWORK,
        R_CONTACTINFO,
        RW_NUS,
        RW_COMPANY_ADMIN,
        RW_GROUPS,
        W_MESSAGES,
        W_SHARE;
    }
    /**
     * Linkedin (camel-linkedin)
     * The linkedin component is used for retrieving LinkedIn user profiles,
     * connections, companies, groups, posts, etc.
     * 
     * Category: api,cloud,social
     * Available as of version: 2.14
     * Maven coordinates: org.apache.camel:camel-linkedin
     * 
     * Syntax: <code>linkedin:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: comments, companies, groups, jobs, people,
     * posts, search
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * The value can be one of: addActivity, addComment,
     * addCompanyUpdateComment, addCompanyUpdateCommentAsCompany,
     * addGroupMembership, addInvite, addJob, addJobBookmark, addPost, addShare,
     * addUpdateComment, editJob, flagCategory, followCompany, followPost,
     * getComment, getCompanies, getCompanyById, getCompanyByName,
     * getCompanyUpdateComments, getCompanyUpdateLikes, getCompanyUpdates,
     * getConnections, getConnectionsById, getConnectionsByUrl,
     * getFollowedCompanies, getGroup, getGroupMemberships,
     * getGroupMembershipSettings, getHistoricalFollowStatistics,
     * getHistoricalStatusUpdateStatistics, getJob, getJobBookmarks,
     * getNetworkStats, getNetworkUpdates, getNetworkUpdatesById,
     * getNumberOfFollowers, getPerson, getPersonById, getPersonByUrl, getPost,
     * getPostComments, getPosts, getStatistics, getSuggestedCompanies,
     * getSuggestedGroupPosts, getSuggestedGroups, getSuggestedJobs,
     * getUpdateComments, getUpdateLikes, isShareEnabled, isViewerShareEnabled,
     * likeCompanyUpdate, likePost, likeUpdate, removeComment,
     * removeGroupMembership, removeGroupSuggestion, removeJob,
     * removeJobBookmark, removePost, searchCompanies, searchJobs, searchPeople,
     * share, stopFollowingCompany, updateGroupMembership
     */
    default LinkedInEndpointBuilder linkedIn(String path) {
        class LinkedInEndpointBuilderImpl extends AbstractEndpointBuilder implements LinkedInEndpointBuilder, AdvancedLinkedInEndpointBuilder {
            public LinkedInEndpointBuilderImpl(String path) {
                super("linkedin", path);
            }
        }
        return new LinkedInEndpointBuilderImpl(path);
    }
}