/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

/**
 * The jt400 component allows you to exchanges messages with an AS/400 system
 * using data queues or program call.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Jt400EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JT400 component.
     */
    public interface Jt400EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJt400EndpointConsumerBuilder advanced() {
            return (AdvancedJt400EndpointConsumerBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder ccsid(int ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder ccsid(String ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder format(Format format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder guiAvailable(boolean guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder guiAvailable(String guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder keyed(boolean keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder keyed(String keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder outputFieldsIdxArray(
                Integer[] outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder outputFieldsIdxArray(
                String outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder outputFieldsLengthArray(
                Integer[] outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder outputFieldsLengthArray(
                String outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder searchKey(String searchKey) {
            setProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder searchType(SearchType searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointConsumerBuilder searchType(String searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Timeout in millis the consumer will wait while trying to read a new
         * message of the data queue.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder readTimeout(int readTimeout) {
            setProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Timeout in millis the consumer will wait while trying to read a new
         * message of the data queue.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder readTimeout(String readTimeout) {
            setProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default Jt400EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder initialDelay(String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder scheduler(
                ScheduledPollConsumerScheduler scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default Jt400EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Procedure name from a service program to call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: procedureName
         */
        default Jt400EndpointConsumerBuilder procedureName(String procedureName) {
            setProperty("procedureName", procedureName);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointConsumerBuilder secured(boolean secured) {
            setProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointConsumerBuilder secured(String secured) {
            setProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JT400 component.
     */
    public interface AdvancedJt400EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Jt400EndpointConsumerBuilder basic() {
            return (Jt400EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJt400EndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JT400 component.
     */
    public interface Jt400EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJt400EndpointProducerBuilder advanced() {
            return (AdvancedJt400EndpointProducerBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder ccsid(int ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder ccsid(String ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder format(Format format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder guiAvailable(boolean guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder guiAvailable(String guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder keyed(boolean keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder keyed(String keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder outputFieldsIdxArray(
                Integer[] outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder outputFieldsIdxArray(
                String outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder outputFieldsLengthArray(
                Integer[] outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder outputFieldsLengthArray(
                String outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder searchKey(String searchKey) {
            setProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder searchType(SearchType searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointProducerBuilder searchType(String searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Jt400EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default Jt400EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Procedure name from a service program to call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: procedureName
         */
        default Jt400EndpointProducerBuilder procedureName(String procedureName) {
            setProperty("procedureName", procedureName);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointProducerBuilder secured(boolean secured) {
            setProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointProducerBuilder secured(String secured) {
            setProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JT400 component.
     */
    public interface AdvancedJt400EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Jt400EndpointProducerBuilder basic() {
            return (Jt400EndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JT400 component.
     */
    public interface Jt400EndpointBuilder
            extends
                Jt400EndpointConsumerBuilder, Jt400EndpointProducerBuilder {
        default AdvancedJt400EndpointBuilder advanced() {
            return (AdvancedJt400EndpointBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder ccsid(int ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the AS/400 system.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder ccsid(String ccsid) {
            setProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder format(Format format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder guiAvailable(boolean guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether AS/400 prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder guiAvailable(String guiAvailable) {
            setProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder keyed(boolean keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder keyed(String keyed) {
            setProperty("keyed", keyed);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder outputFieldsIdxArray(
                Integer[] outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder outputFieldsIdxArray(
                String outputFieldsIdxArray) {
            setProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option is a: <code>java.lang.Integer[]</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder outputFieldsLengthArray(
                Integer[] outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the AS/400
         * program definition.
         * 
         * The option will be converted to a <code>java.lang.Integer[]</code>
         * type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder outputFieldsLengthArray(
                String outputFieldsLengthArray) {
            setProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder searchKey(String searchKey) {
            setProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder searchType(SearchType searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> type.
         * 
         * Group: common
         */
        default Jt400EndpointBuilder searchType(String searchType) {
            setProperty("searchType", searchType);
            return this;
        }
        /**
         * Procedure name from a service program to call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: procedureName
         */
        default Jt400EndpointBuilder procedureName(String procedureName) {
            setProperty("procedureName", procedureName);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointBuilder secured(boolean secured) {
            setProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to AS/400 are secured with SSL.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default Jt400EndpointBuilder secured(String secured) {
            setProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JT400 component.
     */
    public interface AdvancedJt400EndpointBuilder
            extends
                AdvancedJt400EndpointConsumerBuilder, AdvancedJt400EndpointProducerBuilder {
        default Jt400EndpointBuilder basic() {
            return (Jt400EndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJt400EndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code>
     * enum.
     */
    enum Format {
        text,
        binary;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> enum.
     */
    enum SearchType {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;
    }
    /**
     * JT400 (camel-jt400)
     * The jt400 component allows you to exchanges messages with an AS/400
     * system using data queues or program call.
     * 
     * Category: messaging
     * Available as of version: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     * 
     * Syntax: <code>jt400:userID:password/systemName/objectPath.type</code>
     * 
     * Path parameter: userID (required)
     * Returns the ID of the AS/400 user.
     * 
     * Path parameter: password (required)
     * Returns the password of the AS/400 user.
     * 
     * Path parameter: systemName (required)
     * Returns the name of the AS/400 system.
     * 
     * Path parameter: objectPath (required)
     * Returns the fully qualified integrated file system path name of the
     * target object of this endpoint.
     * 
     * Path parameter: type (required)
     * Whether to work with data queues or remote program call
     * The value can be one of: DTAQ, PGM, SRVPGM
     */
    default Jt400EndpointBuilder jt400(String path) {
        class Jt400EndpointBuilderImpl extends AbstractEndpointBuilder implements Jt400EndpointBuilder, AdvancedJt400EndpointBuilder {
            public Jt400EndpointBuilderImpl(String path) {
                super("jt400", path);
            }
        }
        return new Jt400EndpointBuilderImpl(path);
    }
}