/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The fhir component is used for working with the FHIR protocol (health care).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FhirEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the FHIR component.
     */
    public interface FhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFhirEndpointConsumerBuilder advanced() {
            return (AdvancedFhirEndpointConsumerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder encoding(EncodingEnum encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder fhirVersion(
                FhirVersionEnum fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder fhirVersion(String fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder log(boolean log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder log(String log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder prettyPrint(boolean prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder prettyPrint(String prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder serverUrl(String serverUrl) {
            setProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPassword(String proxyPassword) {
            setProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyUser(String proxyUser) {
            setProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the FHIR component.
     */
    public interface AdvancedFhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FhirEndpointConsumerBuilder basic() {
            return (FhirEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder client(Object client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder client(String client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                Object clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                String clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder compress(boolean compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder compress(String compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                Integer connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                boolean deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                String deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                Object fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                String fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder sessionCookie(
                String sessionCookie) {
            setProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                Integer socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder summary(SummaryEnum summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder summary(String summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder validationMode(
                String validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the FHIR component.
     */
    public interface FhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFhirEndpointProducerBuilder advanced() {
            return (AdvancedFhirEndpointProducerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder encoding(EncodingEnum encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder fhirVersion(
                FhirVersionEnum fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder fhirVersion(String fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder log(boolean log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder log(String log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder prettyPrint(boolean prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder prettyPrint(String prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder serverUrl(String serverUrl) {
            setProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPassword(String proxyPassword) {
            setProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyUser(String proxyUser) {
            setProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the FHIR component.
     */
    public interface AdvancedFhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FhirEndpointProducerBuilder basic() {
            return (FhirEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder client(Object client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder client(String client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                Object clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                String clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder compress(boolean compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder compress(String compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                Integer connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                boolean deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                String deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                Object fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                String fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder sessionCookie(
                String sessionCookie) {
            setProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                Integer socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder summary(SummaryEnum summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder summary(String summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder validationMode(
                String validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint for the FHIR component.
     */
    public interface FhirEndpointBuilder
            extends
                FhirEndpointConsumerBuilder, FhirEndpointProducerBuilder {
        default AdvancedFhirEndpointBuilder advanced() {
            return (AdvancedFhirEndpointBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder encoding(EncodingEnum encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder encoding(String encoding) {
            setProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder fhirVersion(FhirVersionEnum fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder fhirVersion(String fhirVersion) {
            setProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder log(boolean log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder log(String log) {
            setProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder prettyPrint(boolean prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder prettyPrint(String prettyPrint) {
            setProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder serverUrl(String serverUrl) {
            setProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPassword(String proxyPassword) {
            setProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyUser(String proxyUser) {
            setProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the FHIR component.
     */
    public interface AdvancedFhirEndpointBuilder
            extends
                AdvancedFhirEndpointConsumerBuilder, AdvancedFhirEndpointProducerBuilder {
        default FhirEndpointBuilder basic() {
            return (FhirEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder client(Object client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder client(String client) {
            setProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder clientFactory(Object clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder clientFactory(String clientFactory) {
            setProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder compress(boolean compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder compress(String compress) {
            setProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                Integer connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            setProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                boolean deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                String deferModelScanning) {
            setProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder fhirContext(Object fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder fhirContext(String fhirContext) {
            setProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            setProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder sessionCookie(String sessionCookie) {
            setProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder socketTimeout(Integer socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder socketTimeout(String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder summary(SummaryEnum summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder summary(String summary) {
            setProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder validationMode(String validationMode) {
            setProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.rest.api.EncodingEnum</code> enum.
     */
    enum EncodingEnum {
        JSON,
        XML;
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.context.FhirVersionEnum</code> enum.
     */
    enum FhirVersionEnum {
        DSTU2,
        DSTU2_HL7ORG,
        DSTU2_1,
        DSTU3,
        R4;
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.rest.api.SummaryEnum</code> enum.
     */
    enum SummaryEnum {
        COUNT,
        TEXT,
        DATA,
        TRUE,
        FALSE;
    }

    /**
     * Proxy enum for
     * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code> enum.
     */
    enum ServerValidationModeEnum {
        NEVER,
        ONCE;
    }
    /**
     * FHIR (camel-fhir)
     * The fhir component is used for working with the FHIR protocol (health
     * care).
     * 
     * Category: hl7,api
     * Available as of version: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     * 
     * Syntax: <code>fhir:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: capabilities, create, delete, history,
     * load-page, meta, patch, read, search, transaction, update, validate
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     */
    default FhirEndpointBuilder fhir(String path) {
        class FhirEndpointBuilderImpl extends AbstractEndpointBuilder implements FhirEndpointBuilder, AdvancedFhirEndpointBuilder {
            public FhirEndpointBuilderImpl(String path) {
                super("fhir", path);
            }
        }
        return new FhirEndpointBuilderImpl(path);
    }
}