/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

/**
 * The cql component aims at integrating Cassandra 2.0 using the CQL3 API (not
 * the Thrift API).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CassandraEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Cassandra CQL component.
     */
    public interface CassandraEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCassandraEndpointConsumerBuilder advanced() {
            return (AdvancedCassandraEndpointConsumerBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cluster(Object cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cluster(String cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder clusterName(String clusterName) {
            setProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder consistencyLevel(
                String consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cql(String cql) {
            setProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            setProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder prepareStatements(
                boolean prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder prepareStatements(
                String prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder session(Object session) {
            setProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder session(String session) {
            setProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduler(
                ScheduledPollConsumerScheduler scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CassandraEndpointConsumerBuilder basic() {
            return (CassandraEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Cassandra CQL component.
     */
    public interface CassandraEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCassandraEndpointProducerBuilder advanced() {
            return (AdvancedCassandraEndpointProducerBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cluster(Object cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cluster(String cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder clusterName(String clusterName) {
            setProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder consistencyLevel(
                String consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cql(String cql) {
            setProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            setProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder prepareStatements(
                boolean prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder prepareStatements(
                String prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder session(Object session) {
            setProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder session(String session) {
            setProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default CassandraEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default CassandraEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CassandraEndpointProducerBuilder basic() {
            return (CassandraEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Cassandra CQL component.
     */
    public interface CassandraEndpointBuilder
            extends
                CassandraEndpointConsumerBuilder, CassandraEndpointProducerBuilder {
        default AdvancedCassandraEndpointBuilder advanced() {
            return (AdvancedCassandraEndpointBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cluster(Object cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cluster(String cluster) {
            setProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder clusterName(String clusterName) {
            setProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder consistencyLevel(
                String consistencyLevel) {
            setProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cql(String cql) {
            setProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            setProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder prepareStatements(
                boolean prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder prepareStatements(
                String prepareStatements) {
            setProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            setProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder session(Object session) {
            setProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder session(String session) {
            setProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointBuilder
            extends
                AdvancedCassandraEndpointConsumerBuilder, AdvancedCassandraEndpointProducerBuilder {
        default CassandraEndpointBuilder basic() {
            return (CassandraEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.datastax.driver.core.ConsistencyLevel</code>
     * enum.
     */
    enum ConsistencyLevel {
        ANY,
        ONE,
        TWO,
        THREE,
        QUORUM,
        ALL,
        LOCAL_QUORUM,
        EACH_QUORUM,
        SERIAL,
        LOCAL_SERIAL,
        LOCAL_ONE;
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * The cql component aims at integrating Cassandra 2.0 using the CQL3 API
     * (not the Thrift API).
     * 
     * Category: database,nosql
     * Available as of version: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     * 
     * Syntax: <code>cql:beanRef:hosts:port/keyspace</code>
     * 
     * Path parameter: beanRef
     * beanRef is defined using bean:id
     * 
     * Path parameter: hosts
     * Hostname(s) cassansdra server(s). Multiple hosts can be separated by
     * comma.
     * 
     * Path parameter: port
     * Port number of cassansdra server(s)
     * 
     * Path parameter: keyspace
     * Keyspace to use
     */
    default CassandraEndpointBuilder cassandra(String path) {
        class CassandraEndpointBuilderImpl extends AbstractEndpointBuilder implements CassandraEndpointBuilder, AdvancedCassandraEndpointBuilder {
            public CassandraEndpointBuilderImpl(String path) {
                super("cql", path);
            }
        }
        return new CassandraEndpointBuilderImpl(path);
    }
}