/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * For uploading downloading and managing files folders groups collaborations
 * etc on box DOT com.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BoxEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Box component.
     */
    public interface BoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBoxEndpointConsumerBuilder advanced() {
            return (AdvancedBoxEndpointConsumerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder enterpriseId(String enterpriseId) {
            setProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: authentication
         */
        default BoxEndpointConsumerBuilder authenticationType(
                String authenticationType) {
            setProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder privateKeyFile(String privateKeyFile) {
            setProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder privateKeyPassword(
                String privateKeyPassword) {
            setProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder publicKeyId(String publicKeyId) {
            setProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Box component.
     */
    public interface AdvancedBoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BoxEndpointConsumerBuilder basic() {
            return (BoxEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                Object accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                String accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                int maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                String maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Box component.
     */
    public interface BoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBoxEndpointProducerBuilder advanced() {
            return (AdvancedBoxEndpointProducerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder enterpriseId(String enterpriseId) {
            setProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default BoxEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default BoxEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: authentication
         */
        default BoxEndpointProducerBuilder authenticationType(
                String authenticationType) {
            setProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder privateKeyFile(String privateKeyFile) {
            setProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder privateKeyPassword(
                String privateKeyPassword) {
            setProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder publicKeyId(String publicKeyId) {
            setProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Box component.
     */
    public interface AdvancedBoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BoxEndpointProducerBuilder basic() {
            return (BoxEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                Object accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                String accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                int maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                String maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Box component.
     */
    public interface BoxEndpointBuilder
            extends
                BoxEndpointConsumerBuilder, BoxEndpointProducerBuilder {
        default AdvancedBoxEndpointBuilder advanced() {
            return (AdvancedBoxEndpointBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder clientId(String clientId) {
            setProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder enterpriseId(String enterpriseId) {
            setProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder clientSecret(String clientSecret) {
            setProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: authentication
         */
        default BoxEndpointBuilder authenticationType(String authenticationType) {
            setProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder privateKeyFile(String privateKeyFile) {
            setProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder privateKeyPassword(String privateKeyPassword) {
            setProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder publicKeyId(String publicKeyId) {
            setProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder userName(String userName) {
            setProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder userPassword(String userPassword) {
            setProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Box component.
     */
    public interface AdvancedBoxEndpointBuilder
            extends
                AdvancedBoxEndpointConsumerBuilder, AdvancedBoxEndpointProducerBuilder {
        default BoxEndpointBuilder basic() {
            return (BoxEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder httpParams(
                Map<String, Object> httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder httpParams(String httpParams) {
            setProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                Object accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                String accessTokenCache) {
            setProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            setProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(int maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(
                String maxCacheEntries) {
            setProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.box.sdk.EncryptionAlgorithm</code> enum.
     */
    enum EncryptionAlgorithm {
        RSA_SHA_256,
        RSA_SHA_384,
        RSA_SHA_512;
    }
    /**
     * Box (camel-box)
     * For uploading downloading and managing files folders groups
     * collaborations etc on box DOT com.
     * 
     * Category: api,file,cloud
     * Available as of version: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * Syntax: <code>box:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: COLLABORATIONS, COMMENTS, EVENT_LOGS, FILES,
     * FOLDERS, GROUPS, EVENTS, SEARCH, TASKS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     */
    default BoxEndpointBuilder box(String path) {
        class BoxEndpointBuilderImpl extends AbstractEndpointBuilder implements BoxEndpointBuilder, AdvancedBoxEndpointBuilder {
            public BoxEndpointBuilderImpl(String path) {
                super("box", path);
            }
        }
        return new BoxEndpointBuilderImpl(path);
    }
}