/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The atomix-messaging component is used to access Atomix's group messaging.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AtomixMessagingEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAtomixMessagingEndpointConsumerBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointConsumerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: <code>io.atomix.AtomixClient</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder atomix(Object atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a <code>io.atomix.AtomixClient</code>
         * type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder atomix(String atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder broadcastType(
                BroadcastType broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder broadcastType(
                String broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder channelName(
                String channelName) {
            setProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            setProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder defaultAction(
                Action defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder defaultAction(
                String defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder memberName(
                String memberName) {
            setProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder nodes(List<Object> nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder nodes(String nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder resultHeader(
                String resultHeader) {
            setProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option is a:
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder transport(
                Class<Object> transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointConsumerBuilder transport(
                String transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default AtomixMessagingEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default AtomixMessagingEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Atomix Messaging
     * component.
     */
    public interface AdvancedAtomixMessagingEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AtomixMessagingEndpointConsumerBuilder basic() {
            return (AtomixMessagingEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder ephemeral(
                boolean ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder ephemeral(
                String ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a: <code>io.atomix.resource.ReadConsistency</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder readConsistency(
                ReadConsistency readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * <code>io.atomix.resource.ReadConsistency</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder readConsistency(
                String readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceConfigs(
                String resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceOptions(
                String resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAtomixMessagingEndpointProducerBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointProducerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: <code>io.atomix.AtomixClient</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder atomix(Object atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a <code>io.atomix.AtomixClient</code>
         * type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder atomix(String atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder broadcastType(
                BroadcastType broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder broadcastType(
                String broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder channelName(
                String channelName) {
            setProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder configurationUri(
                String configurationUri) {
            setProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder defaultAction(
                Action defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder defaultAction(
                String defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder memberName(
                String memberName) {
            setProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder nodes(List<Object> nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder nodes(String nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder resultHeader(
                String resultHeader) {
            setProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option is a:
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder transport(
                Class<Object> transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointProducerBuilder transport(
                String transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default AtomixMessagingEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default AtomixMessagingEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Atomix Messaging
     * component.
     */
    public interface AdvancedAtomixMessagingEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AtomixMessagingEndpointProducerBuilder basic() {
            return (AtomixMessagingEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder ephemeral(
                boolean ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder ephemeral(
                String ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a: <code>io.atomix.resource.ReadConsistency</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder readConsistency(
                ReadConsistency readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * <code>io.atomix.resource.ReadConsistency</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder readConsistency(
                String readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceConfigs(
                String resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceOptions(
                String resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointBuilder
            extends
                AtomixMessagingEndpointConsumerBuilder, AtomixMessagingEndpointProducerBuilder {
        default AdvancedAtomixMessagingEndpointBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: <code>io.atomix.AtomixClient</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder atomix(Object atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a <code>io.atomix.AtomixClient</code>
         * type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder atomix(String atomix) {
            setProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder broadcastType(
                BroadcastType broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder broadcastType(
                String broadcastType) {
            setProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder channelName(String channelName) {
            setProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder configurationUri(
                String configurationUri) {
            setProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder defaultAction(
                Action defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder defaultAction(
                String defaultAction) {
            setProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder memberName(String memberName) {
            setProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder nodes(List<Object> nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;io.atomix.catalyst.transport.Address&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder nodes(String nodes) {
            setProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder resultHeader(String resultHeader) {
            setProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option is a:
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder transport(Class<Object> transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Sets the Atomix transport.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;io.atomix.catalyst.transport.Transport&gt;</code> type.
         * 
         * Group: common
         */
        default AtomixMessagingEndpointBuilder transport(String transport) {
            setProperty("transport", transport);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Atomix Messaging component.
     */
    public interface AdvancedAtomixMessagingEndpointBuilder
            extends
                AdvancedAtomixMessagingEndpointConsumerBuilder, AdvancedAtomixMessagingEndpointProducerBuilder {
        default AtomixMessagingEndpointBuilder basic() {
            return (AtomixMessagingEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            setProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            setProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder ephemeral(
                boolean ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder ephemeral(
                String ephemeral) {
            setProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a: <code>io.atomix.resource.ReadConsistency</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder readConsistency(
                ReadConsistency readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * <code>io.atomix.resource.ReadConsistency</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder readConsistency(
                String readConsistency) {
            setProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceConfigs(
                String resourceConfigs) {
            setProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * java.util.Properties&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceOptions(
                String resourceOptions) {
            setProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedAtomixMessagingEndpointBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> enum.
     */
    enum BroadcastType {
        ALL,
        RANDOM;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> enum.
     */
    enum Action {
        DIRECT,
        BROADCAST;
    }

    /**
     * Proxy enum for <code>io.atomix.resource.ReadConsistency</code> enum.
     */
    enum ReadConsistency {
        ATOMIC,
        ATOMIC_LEASE,
        SEQUENTIAL,
        LOCAL;
    }
    /**
     * Atomix Messaging (camel-atomix)
     * The atomix-messaging component is used to access Atomix's group
     * messaging.
     * 
     * Category: clustering
     * Available as of version: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * Syntax: <code>atomix-messaging:resourceName</code>
     * 
     * Path parameter: resourceName (required)
     * The distributed resource name
     */
    default AtomixMessagingEndpointBuilder atomixMessaging(String path) {
        class AtomixMessagingEndpointBuilderImpl extends AbstractEndpointBuilder implements AtomixMessagingEndpointBuilder, AdvancedAtomixMessagingEndpointBuilder {
            public AtomixMessagingEndpointBuilderImpl(String path) {
                super("atomix-messaging", path);
            }
        }
        return new AtomixMessagingEndpointBuilderImpl(path);
    }
}