/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.Test;

public class FilterBeanLanguageNonRegistryTest extends ContextTestSupport {

    @Test
    public void testBeanLanguageExp() throws Exception {
        getMockEndpoint("mock:result").expectedBodiesReceived("Camel");

        template.sendBody("direct:start", "Hello World");
        template.sendBody("direct:start", "Camel");
        template.sendBody("direct:start", "Bye World");

        assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                MyBean myBean = new MyBean();

                from("direct:start")
                    .filter(method(myBean, "isGoldCustomer"))
                    .to("mock:result");
            }
        };
    }

    public class MyBean {

        public boolean isGoldCustomer(String name) {
            return "Camel".equals(name);
        }
    }
}
