/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.irc;

/**
 * IRC Constants
 */
public final class IrcConstants {
    public static final String IRC_MESSAGE_TYPE = "irc.messageType";
    public static final String IRC_TARGET = "irc.target";
    public static final String IRC_USER_KICKED = "irc.user.kicked";
    public static final String IRC_USER_HOST = "irc.user.host";
    public static final String IRC_USER_NICK = "irc.user.nick";
    public static final String IRC_USER_SERVERNAME = "irc.user.servername";
    public static final String IRC_USER_USERNAME = "irc.user.username";
    public static final String IRC_NUM = "irc.num";
    public static final String IRC_VALUE = "irc.value";

    private IrcConstants() {
        // Utility class
    }
}
