/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.HPAEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;

public class KubernetesHPAConsumer
extends DefaultConsumer {
    private final Processor processor;
    private ExecutorService executor;
    private HpaConsumerTask hpasWatcher;

    public KubernetesHPAConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.hpasWatcher = new HpaConsumerTask();
        this.executor.submit(this.hpasWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.log.debug("Stopping Kubernetes HPA Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.hpasWatcher != null) {
                    this.hpasWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.hpasWatcher != null) {
                    this.hpasWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class HpaConsumerTask
    implements Runnable {
        private Watch watch;

        HpaConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesHPAConsumer.this.getEndpoint().getKubernetesClient().autoscaling().horizontalPodAutoscalers();
            if (ObjectHelper.isNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                w.inNamespace(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w.withName(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = (Watch)w.watch((Object)new Watcher<HorizontalPodAutoscaler>(){

                public void eventReceived(Watcher.Action action, HorizontalPodAutoscaler resource) {
                    HPAEvent hpae = new HPAEvent(action, resource);
                    Exchange exchange = KubernetesHPAConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)hpae.getHpa());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)hpae.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesHPAConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesHPAConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        KubernetesHPAConsumer.this.log.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

