/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.component.jcache.JCacheEntryEventListener;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCacheConsumer.class);
    private CacheEntryListenerConfiguration<Object, Object> entryListenerConfiguration = null;

    public JCacheConsumer(JCacheEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        if (this.entryListenerConfiguration != null) {
            this.getCache().deregisterCacheEntryListener(this.entryListenerConfiguration);
        }
        this.entryListenerConfiguration = this.createEntryListenerConfiguration();
        this.getCache().registerCacheEntryListener(this.entryListenerConfiguration);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.entryListenerConfiguration != null) {
            this.getCache().deregisterCacheEntryListener(this.entryListenerConfiguration);
            this.entryListenerConfiguration = null;
        }
        super.doStop();
    }

    private JCacheEndpoint getJCacheEndpoint() {
        return (JCacheEndpoint)this.getEndpoint();
    }

    private Cache getCache() throws Exception {
        return this.getJCacheEndpoint().getManager().getCache();
    }

    private CacheEntryListenerConfiguration<Object, Object> createEntryListenerConfiguration() {
        return new MutableCacheEntryListenerConfiguration((Factory)new Factory<CacheEntryListener<Object, Object>>(){

            public CacheEntryListener<Object, Object> create() {
                return new JCacheEntryEventListener(){

                    @Override
                    protected void onEvents(Iterable<CacheEntryEvent<?, ?>> events) {
                        for (CacheEntryEvent<?, ?> event : events) {
                            Exchange exchange = JCacheConsumer.this.getEndpoint().createExchange();
                            Message message = exchange.getIn();
                            message.setHeader("CamelJCacheEventType", (Object)event.getEventType().name());
                            message.setHeader("CamelJCacheKey", event.getKey());
                            message.setBody(event.getValue());
                            if (event.isOldValueAvailable()) {
                                message.setHeader("CamelJCacheOldValue", event.getOldValue());
                            }
                            try {
                                JCacheConsumer.this.getProcessor().process(exchange);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error processing event ", (Throwable)e);
                            }
                        }
                    }
                };
            }
        }, (Factory)new Factory<CacheEntryEventFilter<Object, Object>>(){

            public CacheEntryEventFilter<Object, Object> create() {
                return JCacheConsumer.this.getJCacheEndpoint().getManager().getEventFilter();
            }
        }, this.getJCacheEndpoint().getManager().getConfiguration().isOldValueRequired(), this.getJCacheEndpoint().getManager().getConfiguration().isSynchronous());
    }
}

