/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.util;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.twitter.util.TwitterConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.Trend;
import twitter4j.Trends;
import twitter4j.UserList;

public class TwitterConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, String.class, DirectMessage.class, false, (type, exchange, value) -> TwitterConverter.toString((DirectMessage)value));
        this.addTypeConverter(registry, String.class, Status.class, false, (type, exchange, value) -> TwitterConverter.toString((Status)value));
        this.addTypeConverter(registry, String.class, Trend.class, false, (type, exchange, value) -> TwitterConverter.toString((Trend)value));
        this.addTypeConverter(registry, String.class, Trends.class, false, (type, exchange, value) -> TwitterConverter.toString((Trends)value));
        this.addTypeConverter(registry, String.class, UserList.class, false, (type, exchange, value) -> TwitterConverter.toString((UserList)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

