/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.timeline.AbstractStatusConsumerHandler;
import twitter4j.Paging;
import twitter4j.Status;
import twitter4j.TwitterException;

public class UserConsumerHandler
extends AbstractStatusConsumerHandler {
    private String user;

    public UserConsumerHandler(TwitterEndpoint endpoint, String user) {
        super(endpoint);
        this.user = user;
    }

    @Override
    protected List<Status> doPoll() throws TwitterException {
        Paging paging = this.getLastIdPaging();
        this.log.trace("doPoll.getUserTimeline(user={}, sinceId={})", (Object)this.user, (Object)paging.getSinceId());
        return this.getTwitter().getUserTimeline(this.user, paging);
    }

    @Override
    protected List<Status> doDirect() throws TwitterException {
        this.log.trace("doDirect.getUserTimeline(user={})", (Object)this.user);
        return this.getTwitter().getUserTimeline(this.user);
    }
}

