/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.streaming;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.data.StreamingType;
import org.apache.camel.component.twitter.streaming.AbstractStreamingConsumerHandler;
import org.apache.camel.component.twitter.streaming.FilterStreamingConsumerHandler;
import org.apache.camel.component.twitter.streaming.SampleStreamingConsumerHandler;
import org.apache.camel.component.twitter.streaming.TwitterStreamingComponent;
import org.apache.camel.component.twitter.streaming.UserStreamingConsumerHandler;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.10.0", scheme="twitter-streaming", title="Twitter Streaming", syntax="twitter-streaming:streamingType", consumerOnly=true, label="api,social")
public class TwitterStreamingEndpoint
extends AbstractTwitterEndpoint {
    @UriPath(description="The streaming type to consume.")
    @Metadata(required=true)
    private StreamingType streamingType;
    @UriParam(description="Can be used for a streaming filter. Multiple values can be separated with comma.", label="consumer,filter")
    private String keywords;

    public TwitterStreamingEndpoint(String uri, String remaining, String keywords, TwitterStreamingComponent component, TwitterConfiguration properties) {
        super(uri, component, properties);
        if (remaining == null) {
            throw new IllegalArgumentException(String.format("The streaming type must be specified for '%s'", uri));
        }
        this.streamingType = (StreamingType)((Object)component.getCamelContext().getTypeConverter().convertTo(StreamingType.class, (Object)remaining));
        this.keywords = keywords;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported for twitter-streaming");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractStreamingConsumerHandler handler;
        switch (this.streamingType) {
            case SAMPLE: {
                handler = new SampleStreamingConsumerHandler(this);
                break;
            }
            case FILTER: {
                handler = new FilterStreamingConsumerHandler(this, this.keywords);
                break;
            }
            case USER: {
                handler = new UserStreamingConsumerHandler(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create any consumer with uri " + this.getEndpointUri() + ". A streaming type was not provided (or an incorrect pairing was used).");
            }
        }
        return TwitterHelper.createConsumer(processor, this, handler);
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }
}

