/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventListener;
import org.apache.camel.component.twitter.streaming.AbstractStreamingConsumerHandler;
import org.apache.camel.support.ScheduledPollConsumer;

public class DefaultTwitterConsumer
extends ScheduledPollConsumer
implements TwitterEventListener {
    public static final long DEFAULT_CONSUMER_DELAY = 30000L;
    private final AbstractTwitterEndpoint endpoint;
    private final AbstractTwitterConsumerHandler handler;

    public DefaultTwitterConsumer(AbstractTwitterEndpoint endpoint, Processor processor, AbstractTwitterConsumerHandler handler) {
        super((Endpoint)endpoint, processor);
        this.setDelay(30000L);
        this.endpoint = endpoint;
        this.handler = handler;
    }

    public AbstractTwitterEndpoint getEndpoint() {
        return (AbstractTwitterEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        switch (this.endpoint.getEndpointType()) {
            case POLLING: {
                if (!(this.handler instanceof AbstractStreamingConsumerHandler)) break;
                ((AbstractStreamingConsumerHandler)this.handler).start();
                break;
            }
            case EVENT: {
                if (!(this.handler instanceof AbstractStreamingConsumerHandler)) break;
                ((AbstractStreamingConsumerHandler)this.handler).setEventListener(this);
                ((AbstractStreamingConsumerHandler)this.handler).start();
                break;
            }
            default: {
                List<Exchange> exchanges = this.handler.directConsume();
                for (int i = 0; i < exchanges.size(); ++i) {
                    this.getProcessor().process(exchanges.get(i));
                }
            }
        }
    }

    protected void doStop() throws Exception {
        switch (this.endpoint.getEndpointType()) {
            case POLLING: {
                if (!(this.handler instanceof AbstractStreamingConsumerHandler)) break;
                ((AbstractStreamingConsumerHandler)this.handler).stop();
                break;
            }
            case EVENT: {
                if (!(this.handler instanceof AbstractStreamingConsumerHandler)) break;
                ((AbstractStreamingConsumerHandler)this.handler).removeEventListener(this);
                ((AbstractStreamingConsumerHandler)this.handler).stop();
                break;
            }
        }
        super.doStop();
    }

    protected int poll() throws Exception {
        int index;
        List<Exchange> exchanges = this.handler.pollConsume();
        for (index = 0; index < exchanges.size(); ++index) {
            this.getProcessor().process(exchanges.get(index));
        }
        return index;
    }

    @Override
    public void onEvent(Exchange exchange) {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange on status update", exchange, (Throwable)exchange.getException());
        }
    }
}

