/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.lang.management.ManagementFactory;
import java.util.UUID;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.GaugeMonitor;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitor;
import org.apache.camel.Processor;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXEndpoint;

public class JMXMonitorConsumer
extends JMXConsumer {
    ObjectName mMonitorObjectName;

    public JMXMonitorConsumer(JMXEndpoint aEndpoint, Processor aProcessor) {
        super(aEndpoint, aProcessor);
    }

    @Override
    protected void addNotificationListener() throws Exception {
        JMXEndpoint ep = this.getEndpoint();
        Monitor bean = null;
        if (ep.getMonitorType().equals("counter")) {
            CounterMonitor counter = new CounterMonitor();
            Number initThreshold = this.convertNumberToAttributeType(ep.getInitThreshold(), ep.getJMXObjectName(), ep.getObservedAttribute());
            Number offset = this.convertNumberToAttributeType(ep.getOffset(), ep.getJMXObjectName(), ep.getObservedAttribute());
            Number modulus = this.convertNumberToAttributeType(ep.getModulus(), ep.getJMXObjectName(), ep.getObservedAttribute());
            counter.setInitThreshold(initThreshold);
            counter.setOffset(offset);
            counter.setModulus(modulus);
            counter.setDifferenceMode(ep.isDifferenceMode());
            counter.setNotify(true);
            bean = counter;
        } else if (ep.getMonitorType().equals("gauge")) {
            GaugeMonitor gm = new GaugeMonitor();
            gm.setNotifyHigh(ep.isNotifyHigh());
            gm.setNotifyLow(ep.isNotifyLow());
            gm.setDifferenceMode(ep.isDifferenceMode());
            Number highValue = this.convertNumberToAttributeType(ep.getThresholdHigh(), ep.getJMXObjectName(), ep.getObservedAttribute());
            Number lowValue = this.convertNumberToAttributeType(ep.getThresholdLow(), ep.getJMXObjectName(), ep.getObservedAttribute());
            gm.setThresholds(highValue, lowValue);
            bean = gm;
        } else if (ep.getMonitorType().equals("string")) {
            StringMonitor sm = new StringMonitor();
            sm.setNotifyDiffer(ep.isNotifyDiffer());
            sm.setNotifyMatch(ep.isNotifyMatch());
            sm.setStringToCompare(ep.getStringToCompare());
            bean = sm;
        } else {
            throw new IllegalArgumentException("Unsupported monitortype: " + ep.getMonitorType());
        }
        bean.addObservedObject(ep.getJMXObjectName());
        bean.setObservedAttribute(ep.getObservedAttribute());
        bean.setGranularityPeriod(ep.getGranularityPeriod());
        this.mMonitorObjectName = new ObjectName(ep.getObjectDomain(), "name", "camel-jmx-monitor-" + UUID.randomUUID());
        ManagementFactory.getPlatformMBeanServer().registerMBean(bean, this.mMonitorObjectName);
        NotificationFilter nf = ep.getNotificationFilter();
        this.getServerConnection().addNotificationListener(this.mMonitorObjectName, this, nf, (Object)bean);
        bean.start();
    }

    @Override
    protected void removeNotificationListeners() throws Exception {
        ManagementFactory.getPlatformMBeanServer().removeNotificationListener(this.mMonitorObjectName, this);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mMonitorObjectName);
    }

    private Number convertNumberToAttributeType(Number toConvert, ObjectName jmxObjectName, String observedAttribute) throws InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        Object attr = ManagementFactory.getPlatformMBeanServer().getAttribute(jmxObjectName, observedAttribute);
        if (attr instanceof Byte) {
            return toConvert != null ? Byte.valueOf(toConvert.byteValue()) : null;
        }
        if (attr instanceof Integer) {
            return toConvert != null ? Integer.valueOf(toConvert.intValue()) : null;
        }
        if (attr instanceof Short) {
            return toConvert != null ? Short.valueOf(toConvert.shortValue()) : null;
        }
        if (attr instanceof Long) {
            return toConvert != null ? Long.valueOf(toConvert.longValue()) : null;
        }
        if (attr instanceof Float) {
            return toConvert != null ? Float.valueOf(toConvert.floatValue()) : null;
        }
        return toConvert;
    }
}

