/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.lambda.LambdaComponentVerifierExtension;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.apache.camel.component.aws.lambda.LambdaEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws-lambda")
public class LambdaComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private LambdaConfiguration configuration = new LambdaConfiguration();

    public LambdaComponent() {
        this(null);
    }

    public LambdaComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new LambdaComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LambdaConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        configuration.setFunction(remaining);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        this.checkAndSetRegistryClient(configuration);
        if (ObjectHelper.isEmpty((Object)configuration.getAwsLambdaClient()) && (ObjectHelper.isEmpty((Object)configuration.getAccessKey()) || ObjectHelper.isEmpty((Object)configuration.getSecretKey()))) {
            throw new IllegalArgumentException("accessKey/secretKey or awsLambdaClient must be specified");
        }
        LambdaEndpoint endpoint = new LambdaEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }

    public LambdaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(LambdaConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }

    private void checkAndSetRegistryClient(LambdaConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSLambda.class);
        if (clients.size() == 1) {
            configuration.setAwsLambdaClient((AWSLambda)clients.stream().findFirst().get());
        }
    }
}

