/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.model.Record;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.camel.Converter;

@Converter(loader=true, ignoreOnLoadError=true)
public final class RecordStringConverter {
    private RecordStringConverter() {
    }

    @Converter
    public static String toString(Record record) {
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer buffer = record.getData();
        if (buffer.hasArray()) {
            byte[] bytes = record.getData().array();
            return new String(bytes, charset);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, charset);
    }
}

