/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.kinesis.KinesisComponent;
import org.apache.camel.component.aws.kinesis.KinesisConfiguration;
import org.apache.camel.component.aws.kinesis.KinesisConsumer;
import org.apache.camel.component.aws.kinesis.KinesisProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.17.0", scheme="aws-kinesis", title="AWS Kinesis", syntax="aws-kinesis:streamName", label="cloud,messaging")
public class KinesisEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private KinesisConfiguration configuration;
    private AmazonKinesis kinesisClient;

    public KinesisEndpoint(String uri, KinesisConfiguration configuration, KinesisComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        AmazonKinesis amazonKinesis = this.kinesisClient = this.configuration.getAmazonKinesisClient() != null ? this.configuration.getAmazonKinesisClient() : this.createKinesisClient();
        if ((this.configuration.getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.configuration.getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) && this.configuration.getSequenceNumber().isEmpty()) {
            throw new IllegalArgumentException("Sequence Number must be specified with iterator Types AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER");
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisClient()) && this.kinesisClient != null) {
            this.kinesisClient.shutdown();
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new KinesisProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KinesisConsumer consumer = new KinesisConsumer(this, processor);
        consumer.setSchedulerProperties(this.getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Record record) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setBody((Object)record);
        exchange.getIn().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)record.getApproximateArrivalTimestamp());
        exchange.getIn().setHeader("CamelAwsKinesisPartitionKey", (Object)record.getPartitionKey());
        exchange.getIn().setHeader("CamelAwsKinesisSequenceNumber", (Object)record.getSequenceNumber());
        return exchange;
    }

    public AmazonKinesis getClient() {
        return this.kinesisClient;
    }

    public KinesisConfiguration getConfiguration() {
        return this.configuration;
    }

    AmazonKinesis createKinesisClient() {
        AmazonKinesis client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonKinesisClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonKinesisClientBuilder.standard() : (AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonKinesisClientBuilder)clientBuilder.withRegion(this.configuration.getRegion());
        }
        client = (AmazonKinesis)clientBuilder.build();
        return client;
    }
}

