/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.channel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultChannel
extends CamelInternalProcessor
implements Channel {
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private NamedNode definition;
    private ManagementInterceptStrategy.InstrumentationProcessor<?> instrumentationProcessor;
    private CamelContext camelContext;
    private RouteContext routeContext;
    private boolean routeScoped = true;

    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }

    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public NamedNode getProcessorDefinition() {
        return this.definition;
    }

    public void setDefinition(NamedNode definition) {
        this.definition = definition;
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startService((Object[])new Object[]{this.errorHandler, this.output});
    }

    protected void doStop() throws Exception {
        if (this.isRouteScoped()) {
            ServiceHelper.stopService((Object[])new Object[]{this.output, this.errorHandler});
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.output, this.errorHandler});
    }

    public boolean isRouteScoped() {
        return this.routeScoped;
    }

    public void initChannel(RouteContext routeContext, NamedNode definition, NamedNode childDefinition, List<InterceptStrategy> interceptors, Processor nextProcessor, NamedNode route, boolean first, boolean routeScoped) throws Exception {
        this.routeContext = routeContext;
        this.definition = definition;
        this.camelContext = routeContext.getCamelContext();
        this.nextProcessor = nextProcessor;
        this.routeScoped = routeScoped;
        if (nextProcessor instanceof CamelContextAware) {
            ((CamelContextAware)nextProcessor).setCamelContext(this.camelContext);
        }
        NamedNode targetOutputDef = childDefinition != null ? childDefinition : definition;
        this.log.debug("Initialize channel for target: '{}'", (Object)targetOutputDef);
        ManagementInterceptStrategy managed = routeContext.getManagementInterceptStrategy();
        if (managed != null) {
            this.instrumentationProcessor = managed.createProcessor(targetOutputDef, nextProcessor);
        }
        if (routeContext.isTracing().booleanValue()) {
            BacklogTracer tracer = this.getOrCreateBacklogTracer();
            this.camelContext.setExtension(BacklogTracer.class, (Object)tracer);
            this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(tracer, targetOutputDef, route, first));
        }
        if (routeContext.isDebugging().booleanValue()) {
            BacklogDebugger debugger = this.getOrCreateBacklogDebugger();
            this.camelContext.addService((Object)debugger);
            this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice(debugger, nextProcessor, targetOutputDef));
        }
        if (routeContext.isMessageHistory().booleanValue()) {
            MessageHistoryFactory factory = this.camelContext.getMessageHistoryFactory();
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(factory, targetOutputDef));
        }
        interceptors.sort((Comparator<InterceptStrategy>)OrderedComparator.get());
        Collections.reverse(interceptors);
        Processor target = nextProcessor;
        for (InterceptStrategy strategy : interceptors) {
            Processor next = target == nextProcessor ? null : nextProcessor;
            Object wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                this.log.warn("Interceptor: " + strategy + " at: " + definition + " does not return an AsyncProcessor instance. This causes the asynchronous routing engine to not work as optimal as possible. See more details at the InterceptStrategy javadoc. Camel will use a bridge to adapt the interceptor to the asynchronous routing engine, but its not the most optimal solution. Please consider changing your interceptor to comply.");
            }
            if (!(wrapped instanceof WrapProcessor)) {
                wrapped = new WrapProcessor((Processor)wrapped, target);
            }
            target = wrapped;
        }
        if (routeContext.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (routeContext.getDelayer() != null && routeContext.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(routeContext.getDelayer()));
        }
        this.output = target;
    }

    public void postInitChannel() throws Exception {
        if (this.instrumentationProcessor != null) {
            boolean redeliveryPossible = false;
            if (this.errorHandler instanceof RedeliveryErrorHandler && (redeliveryPossible = ((RedeliveryErrorHandler)this.errorHandler).determineIfRedeliveryIsEnabled())) {
                Processor currentOutput = ((RedeliveryErrorHandler)this.errorHandler).getOutput();
                this.instrumentationProcessor.setProcessor(currentOutput);
                ((RedeliveryErrorHandler)this.errorHandler).changeOutput((Processor)this.instrumentationProcessor);
            }
            if (!redeliveryPossible) {
                this.addAdvice(CamelInternalProcessor.wrap(this.instrumentationProcessor));
            }
        }
    }

    private BacklogTracer getOrCreateBacklogTracer() {
        Map map;
        BacklogTracer tracer = null;
        if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
            tracer = (BacklogTracer)((Object)map.values().iterator().next());
        }
        if (tracer == null) {
            tracer = (BacklogTracer)((Object)this.camelContext.getExtension(BacklogTracer.class));
        }
        if (tracer == null) {
            tracer = BacklogTracer.createTracer(this.camelContext);
        }
        return tracer;
    }

    private BacklogDebugger getOrCreateBacklogDebugger() {
        Map map;
        BacklogDebugger debugger = null;
        if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
            debugger = (BacklogDebugger)((Object)map.values().iterator().next());
        }
        if (debugger == null) {
            debugger = (BacklogDebugger)((Object)this.camelContext.hasService(BacklogDebugger.class));
        }
        if (debugger == null) {
            debugger = BacklogDebugger.createDebugger(this.camelContext);
        }
        return debugger;
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

