/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ReactiveHelper;
import org.apache.camel.support.service.ServiceHelper;

public class TryProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware {
    protected String id;
    protected final Processor tryProcessor;
    protected final List<Processor> catchClauses;
    protected final Processor finallyProcessor;

    public TryProcessor(Processor tryProcessor, List<Processor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        String catchText = this.catchClauses == null || this.catchClauses.isEmpty() ? "" : " Catches {" + this.catchClauses + "}";
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "}" + catchText + finallyText;
    }

    public String getTraceLabel() {
        return "doTry";
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ReactiveHelper.schedule((Runnable)new TryState(exchange, callback));
        return false;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop)).booleanValue())) {
            this.log.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        return it.hasNext();
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.tryProcessor, this.catchClauses, this.finallyProcessor});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.tryProcessor, this.catchClauses, this.finallyProcessor});
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.tryProcessor != null) {
            answer.add(this.tryProcessor);
        }
        if (this.catchClauses != null) {
            answer.addAll(this.catchClauses);
        }
        if (this.finallyProcessor != null) {
            answer.add(this.finallyProcessor);
        }
        return answer;
    }

    public boolean hasNext() {
        return this.tryProcessor != null || this.catchClauses != null && !this.catchClauses.isEmpty() || this.finallyProcessor != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    class TryState
    implements Runnable {
        final Exchange exchange;
        final AsyncCallback callback;
        final Iterator<Processor> processors;
        final Object lastHandled;

        public TryState(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
            this.processors = TryProcessor.this.next().iterator();
            this.lastHandled = exchange.getProperty("CamelExceptionHandled");
            exchange.setProperty("CamelExceptionHandled", null);
        }

        @Override
        public void run() {
            if (TryProcessor.this.continueRouting(this.processors, this.exchange)) {
                this.exchange.setProperty("TryRouteBlock", (Object)true);
                ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                Processor processor = this.processors.next();
                AsyncProcessor async = AsyncProcessorConverterHelper.convert((Processor)processor);
                TryProcessor.this.log.trace("Processing exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                async.process(this.exchange, doneSync -> ReactiveHelper.schedule((Runnable)this));
            } else {
                ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                this.exchange.removeProperty("TryRouteBlock");
                this.exchange.setProperty("CamelExceptionHandled", this.lastHandled);
                TryProcessor.this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                this.callback.done(false);
            }
        }

        public String toString() {
            return "TryState[" + this.exchange.getExchangeId() + "]";
        }
    }
}

