/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.processor.MarshalProcessor;
import org.apache.camel.support.processor.UnmarshalProcessor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestBindingAdvice
implements CamelInternalProcessorAdvice<Map<String, Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(RestBindingAdvice.class);
    private static final String STATE_KEY_DO_MARSHAL = "doMarshal";
    private static final String STATE_KEY_ACCEPT = "accept";
    private static final String STATE_JSON = "json";
    private static final String STATE_XML = "xml";
    private final AsyncProcessor jsonUnmarshal;
    private final AsyncProcessor xmlUnmarshal;
    private final AsyncProcessor jsonMarshal;
    private final AsyncProcessor xmlMarshal;
    private final String consumes;
    private final String produces;
    private final String bindingMode;
    private final boolean skipBindingOnErrorCode;
    private final boolean clientRequestValidation;
    private final boolean enableCORS;
    private final Map<String, String> corsHeaders;
    private final Map<String, String> queryDefaultValues;
    private final boolean requiredBody;
    private final Set<String> requiredQueryParameters;
    private final Set<String> requiredHeaders;

    public RestBindingAdvice(CamelContext camelContext, DataFormat jsonDataFormat, DataFormat xmlDataFormat, DataFormat outJsonDataFormat, DataFormat outXmlDataFormat, String consumes, String produces, String bindingMode, boolean skipBindingOnErrorCode, boolean clientRequestValidation, boolean enableCORS, Map<String, String> corsHeaders, Map<String, String> queryDefaultValues, boolean requiredBody, Set<String> requiredQueryParameters, Set<String> requiredHeaders) throws Exception {
        this.jsonUnmarshal = jsonDataFormat != null ? new UnmarshalProcessor(jsonDataFormat) : null;
        this.jsonMarshal = outJsonDataFormat != null ? new MarshalProcessor(outJsonDataFormat) : (jsonDataFormat != null ? new MarshalProcessor(jsonDataFormat) : null);
        this.xmlUnmarshal = xmlDataFormat != null ? new UnmarshalProcessor(xmlDataFormat) : null;
        this.xmlMarshal = outXmlDataFormat != null ? new MarshalProcessor(outXmlDataFormat) : (xmlDataFormat != null ? new MarshalProcessor(xmlDataFormat) : null);
        if (this.jsonMarshal != null) {
            camelContext.addService((Object)this.jsonMarshal, true);
        }
        if (this.jsonUnmarshal != null) {
            camelContext.addService((Object)this.jsonUnmarshal, true);
        }
        if (this.xmlMarshal instanceof CamelContextAware) {
            camelContext.addService((Object)this.xmlMarshal, true);
        }
        if (this.xmlUnmarshal instanceof CamelContextAware) {
            camelContext.addService((Object)this.xmlUnmarshal, true);
        }
        this.consumes = consumes;
        this.produces = produces;
        this.bindingMode = bindingMode;
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        this.clientRequestValidation = clientRequestValidation;
        this.enableCORS = enableCORS;
        this.corsHeaders = corsHeaders;
        this.queryDefaultValues = queryDefaultValues;
        this.requiredBody = requiredBody;
        this.requiredQueryParameters = requiredQueryParameters;
        this.requiredHeaders = requiredHeaders;
    }

    public Map<String, Object> before(Exchange exchange) throws Exception {
        HashMap<String, Object> state = new HashMap<String, Object>();
        if (this.isOptionsMethod(exchange, state)) {
            return state;
        }
        this.unmarshal(exchange, state);
        return state;
    }

    public void after(Exchange exchange, Map<String, Object> state) throws Exception {
        if (this.enableCORS) {
            this.setCORSHeaders(exchange, state);
        }
        if (state.get(STATE_KEY_DO_MARSHAL) != null) {
            this.marshal(exchange, state);
        }
    }

    private boolean isOptionsMethod(Exchange exchange, Map<String, Object> state) {
        String method = (String)exchange.getIn().getHeader("CamelHttpMethod", String.class);
        if ("OPTIONS".equalsIgnoreCase(method)) {
            exchange.setProperty("CamelRouteStop", (Object)true);
            return true;
        }
        return false;
    }

    private void unmarshal(Exchange exchange, Map<String, Object> state) throws Exception {
        boolean isXml = false;
        boolean isJson = false;
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson) {
            isXml = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            boolean bl = isJson = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (exchange.getContext().isUseDataType().booleanValue() && exchange.getIn() instanceof DataTypeAware && (isJson || isXml)) {
            ((DataTypeAware)exchange.getIn()).setDataType(new DataType(isJson ? STATE_JSON : STATE_XML));
        }
        if (!(isJson &= this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON)) && !(isXml &= this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML);
            isJson = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON);
        }
        String accept = (String)exchange.getMessage().getHeader("Accept", String.class);
        state.put(STATE_KEY_ACCEPT, accept);
        if (this.clientRequestValidation) {
            if (!RestBindingAdvice.isValidOrAcceptedContentType(this.consumes, contentType)) {
                LOG.trace("Consuming content type does not match contentType header {}. Stopping routing.", (Object)contentType);
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)415);
                exchange.setProperty("CamelRouteStop", (Object)true);
                return;
            }
            if (!RestBindingAdvice.isValidOrAcceptedContentType(this.produces, accept)) {
                LOG.trace("Produced content type does not match accept header {}. Stopping routing.", (Object)contentType);
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)406);
                exchange.setProperty("CamelRouteStop", (Object)true);
                return;
            }
        }
        String body = null;
        if (exchange.getIn().getBody() != null && (isXml || isJson) && (body = MessageHelper.extractBodyAsString((Message)exchange.getIn())) != null) {
            if (exchange.getIn() instanceof DataTypeAware) {
                ((DataTypeAware)exchange.getIn()).setBody((Object)body, new DataType(isJson ? STATE_JSON : STATE_XML));
            } else {
                exchange.getIn().setBody((Object)body);
            }
            if (isXml && isJson) {
                isXml = body.startsWith("<");
                boolean bl = isJson = !isXml;
            }
        }
        if (this.queryDefaultValues != null) {
            for (Map.Entry<String, String> entry : this.queryDefaultValues.entrySet()) {
                if (exchange.getIn().getHeader(entry.getKey()) != null) continue;
                exchange.getIn().setHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.clientRequestValidation) {
            if (this.requiredBody) {
                if (body == null && (body = MessageHelper.extractBodyAsString((Message)exchange.getIn())) != null) {
                    exchange.getIn().setBody((Object)body);
                }
                if (body == null) {
                    exchange.getOut().setHeader("CamelHttpResponseCode", (Object)400);
                    exchange.getOut().setBody((Object)"The request body is missing.");
                    exchange.setProperty("CamelRouteStop", (Object)true);
                    return;
                }
            }
            if (this.requiredQueryParameters != null && !exchange.getIn().getHeaders().keySet().containsAll(this.requiredQueryParameters)) {
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)400);
                exchange.getOut().setBody((Object)"Some of the required query parameters are missing.");
                exchange.setProperty("CamelRouteStop", (Object)true);
                return;
            }
            if (this.requiredHeaders != null && !exchange.getIn().getHeaders().keySet().containsAll(this.requiredHeaders)) {
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)400);
                exchange.getOut().setBody((Object)"Some of the required HTTP headers are missing.");
                exchange.setProperty("CamelRouteStop", (Object)true);
                return;
            }
        }
        if (isJson && this.jsonUnmarshal != null) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_JSON);
            if (ObjectHelper.isNotEmpty((Object)body)) {
                this.jsonUnmarshal.process(exchange);
                ExchangeHelper.prepareOutToIn((Exchange)exchange);
            }
            return;
        }
        if (isXml && this.xmlUnmarshal != null) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_XML);
            if (ObjectHelper.isNotEmpty((Object)body)) {
                this.xmlUnmarshal.process(exchange);
                ExchangeHelper.prepareOutToIn((Exchange)exchange);
            }
            return;
        }
        if ("off".equals(this.bindingMode) || this.bindingMode.equals("auto")) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_JSON);
        } else if (this.bindingMode.contains(STATE_XML)) {
            exchange.setException((Throwable)new CamelExchangeException("Cannot bind to xml as message body is not xml compatible", exchange));
        } else {
            exchange.setException((Throwable)new CamelExchangeException("Cannot bind to json as message body is not json compatible", exchange));
        }
    }

    private void marshal(Exchange exchange, Map<String, Object> state) {
        String contentType;
        if (exchange.getException() != null) {
            return;
        }
        if (this.skipBindingOnErrorCode) {
            Integer code;
            Integer n = code = exchange.hasOut() ? (Integer)exchange.getOut().getHeader("CamelHttpResponseCode", Integer.class) : (Integer)exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class);
            if (code != null && code >= 300) {
                return;
            }
        }
        boolean isXml = false;
        boolean isJson = false;
        String accept = (String)state.get(STATE_KEY_ACCEPT);
        if (accept != null) {
            isXml = accept.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = accept.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson && (contentType = ExchangeHelper.getContentType((Exchange)exchange)) != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson) {
            isXml = this.produces != null && this.produces.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            boolean bl = isJson = this.produces != null && this.produces.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (this.bindingMode != null && !(isJson &= this.bindingMode.equals("off") || this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON)) && !(isXml &= this.bindingMode.equals("off") || this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML);
            boolean bl = isJson = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON);
        }
        if (isXml && isJson) {
            isXml = state.get(STATE_KEY_DO_MARSHAL).equals(STATE_XML);
            isJson = !isXml;
        }
        ExchangeHelper.prepareOutToIn((Exchange)exchange);
        this.ensureHeaderContentType(this.produces, isXml, isJson, exchange);
        if (this.bindingMode == null || "off".equals(this.bindingMode)) {
            return;
        }
        if (this.jsonMarshal == null && this.xmlMarshal == null) {
            return;
        }
        if (exchange.hasOut() && exchange.getOut().getBody() == null || !exchange.hasOut() && exchange.getIn().getBody() == null) {
            return;
        }
        contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        contentType = contentType.toLowerCase(Locale.US);
        try {
            if (isJson && this.jsonMarshal != null) {
                if (contentType.contains(STATE_JSON)) {
                    this.jsonMarshal.process(exchange);
                    this.setOutputDataType(exchange, new DataType(STATE_JSON));
                }
            } else if (isXml && this.xmlMarshal != null) {
                if (contentType.contains(STATE_XML)) {
                    this.xmlMarshal.process(exchange);
                    this.setOutputDataType(exchange, new DataType(STATE_XML));
                }
            } else if (!this.bindingMode.equals("auto")) {
                if (this.bindingMode.contains(STATE_XML)) {
                    exchange.setException((Throwable)new CamelExchangeException("Cannot bind to xml as message body is not xml compatible", exchange));
                } else {
                    exchange.setException((Throwable)new CamelExchangeException("Cannot bind to json as message body is not json compatible", exchange));
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
    }

    private void setOutputDataType(Exchange exchange, DataType type) {
        Message target;
        Message message = target = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        if (target instanceof DataTypeAware) {
            ((DataTypeAware)target).setDataType(type);
        }
    }

    private void ensureHeaderContentType(String contentType, boolean isXml, boolean isJson, Exchange exchange) {
        String type;
        if (contentType != null && (type = ExchangeHelper.getContentType((Exchange)exchange)) == null) {
            exchange.getIn().setHeader("Content-Type", (Object)contentType);
        }
        if (isJson) {
            type = ExchangeHelper.getContentType((Exchange)exchange);
            if (type == null) {
                exchange.getIn().setHeader("Content-Type", (Object)"application/json");
            }
        } else if (isXml && (type = ExchangeHelper.getContentType((Exchange)exchange)) == null) {
            exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
        }
    }

    private void setCORSHeaders(Exchange exchange, Map<String, Object> state) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String string = allowOrigin = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        String allowCredentials = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Credentials") : null;
        String origin = (String)exchange.getIn().getHeader("Origin", String.class);
        if ("true".equalsIgnoreCase(allowCredentials) && "*".equals(allowOrigin) && origin != null) {
            allowOrigin = origin;
        }
        msg.setHeader("Access-Control-Allow-Origin", (Object)allowOrigin);
        msg.setHeader("Access-Control-Allow-Methods", (Object)allowMethods);
        msg.setHeader("Access-Control-Allow-Headers", (Object)allowHeaders);
        msg.setHeader("Access-Control-Max-Age", (Object)maxAge);
        if (allowCredentials != null) {
            msg.setHeader("Access-Control-Allow-Credentials", (Object)allowCredentials);
        }
    }

    private static boolean isValidOrAcceptedContentType(String valid, String target) {
        if (valid == null || target == null) {
            return true;
        }
        if ("*/*".equals(target)) {
            return true;
        }
        boolean isXml = valid.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
        boolean isJson = valid.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        String type = target.toLowerCase(Locale.ENGLISH);
        if (isXml && !type.contains(STATE_XML)) {
            return false;
        }
        return !isJson || type.contains(STATE_JSON);
    }
}

