/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RemoveHeadersProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware {
    private String id;
    private final String pattern;
    private final String[] excludePattern;

    public RemoveHeadersProcessor(String pattern, String[] excludePattern) {
        this.pattern = pattern;
        this.excludePattern = excludePattern;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            message.removeHeaders(this.pattern, this.excludePattern);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "RemoveHeaders(" + this.pattern + ")";
    }

    public String getTraceLabel() {
        return "removeHeaders[" + this.pattern + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getExcludePattern() {
        return this.excludePattern;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

