/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.support.ObjectHelper;

public class DefaultInjector
implements Injector {
    private final CamelBeanPostProcessor postProcessor;

    public DefaultInjector(CamelContext context) {
        this.postProcessor = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(type, true);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        Object answer = ObjectHelper.newInstance(type);
        if (answer != null && postProcessBean) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean: " + answer, (Throwable)e);
            }
        }
        return (T)answer;
    }

    public boolean supportsAutoWiring() {
        return false;
    }
}

