/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProxyFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(BeanProxyFactoryResolver.class);
    private FactoryFinder factoryFinder;

    public BeanProxyFactory resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("bean-proxy-factory", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found BeanProxyFactory: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "bean-proxy-factory"});
            }
            if (BeanProxyFactory.class.isAssignableFrom(type)) {
                BeanProxyFactory answer = (BeanProxyFactory)context.getInjector().newInstance(type, false);
                LOG.debug("Detected and using BeanProxyFactory: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a BeanProxyFactory implementation. Found: " + type.getName());
        }
        LOG.debug("Cannot find BeanProxyFactory. Make sure camel-bean is on the classpath.");
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }
}

