/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.NIOConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class NIOConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, byte[].class, ByteBuffer.class, false, (type, exchange, value) -> NIOConverter.toByteArray((ByteBuffer)value));
        this.addTypeConverter(registry, InputStream.class, ByteBuffer.class, false, (type, exchange, value) -> NIOConverter.toInputStream((ByteBuffer)value));
        this.addTypeConverter(registry, String.class, ByteBuffer.class, false, (type, exchange, value) -> NIOConverter.toString((ByteBuffer)value, exchange));
        this.addTypeConverter(registry, ByteBuffer.class, byte[].class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((byte[])value));
        this.addTypeConverter(registry, ByteBuffer.class, File.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((File)value));
        this.addTypeConverter(registry, ByteBuffer.class, Double.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((Double)value));
        this.addTypeConverter(registry, ByteBuffer.class, Float.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((Float)value));
        this.addTypeConverter(registry, ByteBuffer.class, Integer.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((Integer)value));
        this.addTypeConverter(registry, ByteBuffer.class, Long.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((Long)value));
        this.addTypeConverter(registry, ByteBuffer.class, Short.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((Short)value));
        this.addTypeConverter(registry, ByteBuffer.class, String.class, false, (type, exchange, value) -> NIOConverter.toByteBuffer((String)value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

