/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Language(value="bean")
public class BeanLanguage
extends LanguageSupport {
    private Object bean;
    private Class<?> beanType;
    private String ref;
    private String method;

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        if (this.bean != null) {
            return new BeanExpression(this.bean, this.method);
        }
        if (this.beanType != null) {
            return new BeanExpression(this.beanType, this.method);
        }
        if (this.ref != null) {
            return new BeanExpression(this.ref, this.method);
        }
        String beanName = expression;
        String method = null;
        if (expression.contains("?method=")) {
            beanName = StringHelper.before((String)expression, (String)"?");
            method = StringHelper.after((String)expression, (String)"?method=");
        } else {
            int doubleColonIndex = expression.indexOf("::");
            int beginOfParameterDeclaration = expression.indexOf("(");
            if (!(doubleColonIndex <= 0 || expression.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                beanName = expression.substring(0, doubleColonIndex);
                method = expression.substring(doubleColonIndex + 2);
            } else {
                int idx = expression.indexOf(46);
                if (idx > 0) {
                    beanName = expression.substring(0, idx);
                    method = expression.substring(idx + 1);
                }
            }
        }
        return new BeanExpression(beanName, method);
    }

    public Expression createExpression(Object bean, String method) {
        ObjectHelper.notNull((Object)bean, (String)"bean");
        if (bean instanceof String) {
            String beanName = (String)bean;
            return new BeanExpression(beanName, method);
        }
        return new BeanExpression(bean, method);
    }

    public boolean isSingleton() {
        return false;
    }
}

