/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;

public abstract class AbstractBeanProcessor
extends AsyncProcessorSupport {
    private final BeanHolder beanHolder;
    private transient Processor processor;
    private transient boolean lookupProcessorDone;
    private final Object lock = new Object();
    private Boolean cache;
    private String method;
    private boolean shorthandMethod;

    public AbstractBeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public AbstractBeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public AbstractBeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public AbstractBeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        return "BeanProcessor[" + this.beanHolder + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        MethodInvocation invocation;
        BeanInfo beanInfo;
        Object bean;
        String explicitMethodName = (String)exchange.getIn().getHeader("CamelBeanMethodName", (Object)this.method, String.class);
        try {
            bean = this.beanHolder.getBean();
            beanInfo = this.beanHolder.getBeanInfo(bean);
            if (beanInfo == null) {
                beanInfo = this.beanHolder.getBeanInfo();
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        if (this.allowProcessor(explicitMethodName, beanInfo)) {
            Processor target = this.getProcessor();
            if (target == null) {
                boolean allowCache;
                boolean bl = allowCache = this.cache == null || this.cache != false;
                if (allowCache) {
                    if (!this.lookupProcessorDone) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lookupProcessorDone = true;
                            this.processor = target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
                        }
                    }
                } else {
                    target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
                }
            }
            if (target != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Using a custom adapter as bean invocation: {}", (Object)target);
                }
                try {
                    target.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        Message in = exchange.getIn();
        if (explicitMethodName != null) {
            in.setHeader("CamelBeanMethodName", (Object)explicitMethodName);
        }
        try {
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (explicitMethodName != null) {
                in.removeHeader("CamelBeanMethodName");
            }
        }
        if (invocation == null) {
            exchange.setException((Throwable)new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean));
            callback.done(true);
            return true;
        }
        return invocation.proceed(callback);
    }

    protected Processor getProcessor() {
        return this.processor;
    }

    protected BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public Object getBean() {
        return this.beanHolder.getBean();
    }

    public String getMethod() {
        return this.method;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    protected void doStart() throws Exception {
        if (this.beanHolder.supportProcessor() && this.allowProcessor(this.method, this.beanHolder.getBeanInfo())) {
            this.processor = this.beanHolder.getProcessor();
            ServiceHelper.startService((Object)this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.startService((Object)this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopService((Object)this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.stopService((Object)this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    private boolean allowProcessor(String explicitMethodName, BeanInfo info) {
        if (explicitMethodName != null) {
            return false;
        }
        return !info.hasAnyMethodHandlerAnnotation();
    }
}

