/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class ReactiveStreamsConverterLoader
implements TypeConverterLoader {
    private volatile ReactiveStreamsConverter reactiveStreamsConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        this.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getReactiveStreamsConverter().convertToPublisher(type, exchange, value, registry));
    }

    private void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactiveStreamsConverter getReactiveStreamsConverter() {
        if (this.reactiveStreamsConverter == null) {
            ReactiveStreamsConverterLoader reactiveStreamsConverterLoader = this;
            synchronized (reactiveStreamsConverterLoader) {
                if (this.reactiveStreamsConverter == null) {
                    this.reactiveStreamsConverter = new ReactiveStreamsConverter();
                }
            }
        }
        return this.reactiveStreamsConverter;
    }
}

