/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz2;

import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicyConstants;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class CronScheduledRoutePolicy
extends ScheduledRoutePolicy
implements ScheduledRoutePolicyConstants {
    private String routeStartTime;
    private String routeStopTime;
    private String routeSuspendTime;
    private String routeResumeTime;
    private String timeZoneString;
    private TimeZone timeZone;

    public void onInit(Route route) {
        try {
            this.doOnInit(route);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doOnInit(Route route) throws Exception {
        QuartzComponent quartz = (QuartzComponent)route.getCamelContext().getComponent("quartz2", QuartzComponent.class);
        this.setScheduler(quartz.getScheduler());
        if (this.getRouteStopGracePeriod() == 0) {
            this.setRouteStopGracePeriod(10000);
        }
        if (this.getTimeUnit() == null) {
            this.setTimeUnit(TimeUnit.MILLISECONDS);
        }
        if (this.getRouteStartTime() == null && this.getRouteStopTime() == null && this.getRouteSuspendTime() == null && this.getRouteResumeTime() == null) {
            throw new IllegalArgumentException("Scheduled Route Policy for route " + route.getId() + " has no start/stop/suspend/resume times specified");
        }
        this.registerRouteToScheduledRouteDetails(route);
        if (this.getRouteStartTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START, route);
        }
        if (this.getRouteStopTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP, route);
        }
        if (this.getRouteSuspendTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND, route);
        }
        if (this.getRouteResumeTime() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME, route);
        }
    }

    @Override
    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        Trigger trigger = null;
        CronScheduleBuilder scheduleBuilder = null;
        String triggerPrefix = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.getRouteStartTime());
            triggerPrefix = TRIGGER_START;
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.getRouteStopTime());
            triggerPrefix = TRIGGER_STOP;
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.getRouteSuspendTime());
            triggerPrefix = TRIGGER_SUSPEND;
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.getRouteResumeTime());
            triggerPrefix = TRIGGER_RESUME;
        }
        if (scheduleBuilder != null) {
            if (this.timeZone != null) {
                scheduleBuilder.inTimeZone(this.timeZone);
            }
            TriggerKey triggerKey = new TriggerKey(triggerPrefix + route.getId(), "triggerGroup-" + route.getId());
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        }
        return trigger;
    }

    public void setRouteStartTime(String routeStartTime) {
        this.routeStartTime = routeStartTime;
    }

    public String getRouteStartTime() {
        return this.routeStartTime;
    }

    public void setRouteStopTime(String routeStopTime) {
        this.routeStopTime = routeStopTime;
    }

    public String getRouteStopTime() {
        return this.routeStopTime;
    }

    public void setRouteSuspendTime(String routeSuspendTime) {
        this.routeSuspendTime = routeSuspendTime;
    }

    public String getRouteSuspendTime() {
        return this.routeSuspendTime;
    }

    public void setRouteResumeTime(String routeResumeTime) {
        this.routeResumeTime = routeResumeTime;
    }

    public String getRouteResumeTime() {
        return this.routeResumeTime;
    }

    public String getTimeZone() {
        return this.timeZoneString;
    }

    public void setTimeZone(String timeZone) {
        this.timeZoneString = timeZone;
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }
}

