/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.message.PulsarMessageUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;

public class PulsarProducer
extends DefaultProducer {
    private final PulsarEndpoint pulsarEndpoint;
    private Producer<byte[]> producer;

    public PulsarProducer(PulsarEndpoint pulsarEndpoint) {
        super((Endpoint)pulsarEndpoint);
        this.pulsarEndpoint = pulsarEndpoint;
    }

    public void process(Exchange exchange) throws Exception {
        byte[] body;
        Message message = exchange.getIn();
        try {
            body = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, message.getBody());
        }
        catch (NoTypeConversionAvailableException | TypeConversionException exception) {
            body = PulsarMessageUtils.serialize(message.getBody());
        }
        this.producer.send((Object)body);
    }

    private synchronized void createProducer() throws PulsarClientException {
        if (this.producer == null) {
            String topic = this.pulsarEndpoint.getTopic();
            String producerName = this.pulsarEndpoint.getPulsarConfiguration().getProducerName();
            if (producerName == null) {
                producerName = topic + "-" + Thread.currentThread().getId();
            }
            ProducerBuilder producerBuilder = this.pulsarEndpoint.getPulsarClient().newProducer().producerName(producerName).topic(topic);
            this.producer = producerBuilder.create();
        }
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting producer: {}", (Object)this);
        if (this.producer == null) {
            this.createProducer();
        }
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping producer: {}", (Object)this);
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

