/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarProducer;
import org.apache.camel.component.pulsar.configuration.PulsarConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;

@UriEndpoint(scheme="pulsar", firstVersion="2.24.0", title="Apache Pulsar", syntax="pulsar:persistence://tenant/namespace/topic", label="messaging")
public class PulsarEndpoint
extends DefaultEndpoint {
    private PulsarClient pulsarClient;
    @UriParam
    private PulsarConfiguration pulsarConfiguration;
    @UriPath(label="consumer,producer", description="The Topic's full URI path including type, tenant and namespace")
    private final String topic;

    public PulsarEndpoint(String uri, String path, PulsarConfiguration pulsarConfiguration, PulsarComponent component, PulsarClient pulsarClient) throws PulsarClientException {
        super(uri, (Component)component);
        this.topic = path;
        this.pulsarConfiguration = pulsarConfiguration;
        this.pulsarClient = pulsarClient;
    }

    public static PulsarEndpoint create(String uri, String path, PulsarConfiguration pulsarConfiguration, PulsarComponent component, PulsarClient pulsarClient) throws PulsarClientException, IllegalArgumentException {
        if (null == pulsarConfiguration) {
            throw new IllegalArgumentException("PulsarEndpointConfiguration cannot be null");
        }
        return new PulsarEndpoint(uri, path, pulsarConfiguration, component, pulsarClient);
    }

    public Producer createProducer() {
        return new PulsarProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        PulsarConsumer consumer = new PulsarConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange() {
        return super.createExchange();
    }

    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }

    public PulsarConfiguration getPulsarConfiguration() {
        return this.pulsarConfiguration;
    }

    public String getTopic() {
        return this.topic;
    }
}

