/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.types;

import java.net.InetAddress;
import java.util.List;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.dns.types.DnsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.xbill.DNS.Address;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;

public class DnsConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, String.class, InetAddress.class, false, (type, exchange, value) -> DnsConverter.toString((InetAddress)value));
        this.addTypeConverter(registry, String.class, Address.class, false, (type, exchange, value) -> DnsConverter.toString((Address)value));
        this.addTypeConverter(registry, String.class, Message.class, false, (type, exchange, value) -> DnsConverter.toString((Message)value));
        this.addTypeConverter(registry, String.class, Record.class, false, (type, exchange, value) -> DnsConverter.toString((Record)value));
        this.addTypeConverter(registry, InetAddress.class, String.class, false, (type, exchange, value) -> DnsConverter.toInetAddress((String)value));
        this.addTypeConverter(registry, List.class, Record[].class, false, (type, exchange, value) -> DnsConverter.toList((Record[])value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

