/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.springboot;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.fhir")
public class FhirComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private FhirConfigurationNestedConfiguration configuration;
    private Boolean resolvePropertyPlaceholders = true;
    private Boolean basicPropertyBinding = false;

    public FhirConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(FhirConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public Boolean getBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public static class FhirConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = FhirConfiguration.class;
        private String serverUrl;
        private String fhirVersion = "DSTU3";
        private String encoding;
        private Boolean prettyPrint = false;
        private String summary;
        private FhirApiName apiName;
        private String methodName;
        private FhirContext fhirContext;
        private Boolean forceConformanceCheck = false;
        private String username;
        private String password;
        private String accessToken;
        private Boolean log = false;
        private Boolean compress = false;
        private String sessionCookie;
        private String validationMode = "ONCE";
        private Boolean deferModelScanning = false;
        private Integer connectionTimeout = 10000;
        private Integer socketTimeout = 10000;
        private String proxyHost;
        private String proxyPassword;
        private Integer proxyPort;
        private String proxyUser;
        private IGenericClient client;
        private IRestfulClientFactory clientFactory;

        public String getServerUrl() {
            return this.serverUrl;
        }

        public void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String getFhirVersion() {
            return this.fhirVersion;
        }

        public void setFhirVersion(String fhirVersion) {
            this.fhirVersion = fhirVersion;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public Boolean getPrettyPrint() {
            return this.prettyPrint;
        }

        public void setPrettyPrint(Boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public FhirApiName getApiName() {
            return this.apiName;
        }

        public void setApiName(FhirApiName apiName) {
            this.apiName = apiName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public FhirContext getFhirContext() {
            return this.fhirContext;
        }

        public void setFhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
        }

        public Boolean getForceConformanceCheck() {
            return this.forceConformanceCheck;
        }

        public void setForceConformanceCheck(Boolean forceConformanceCheck) {
            this.forceConformanceCheck = forceConformanceCheck;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public Boolean getLog() {
            return this.log;
        }

        public void setLog(Boolean log) {
            this.log = log;
        }

        public Boolean getCompress() {
            return this.compress;
        }

        public void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public String getSessionCookie() {
            return this.sessionCookie;
        }

        public void setSessionCookie(String sessionCookie) {
            this.sessionCookie = sessionCookie;
        }

        public String getValidationMode() {
            return this.validationMode;
        }

        public void setValidationMode(String validationMode) {
            this.validationMode = validationMode;
        }

        public Boolean getDeferModelScanning() {
            return this.deferModelScanning;
        }

        public void setDeferModelScanning(Boolean deferModelScanning) {
            this.deferModelScanning = deferModelScanning;
        }

        public Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public Integer getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyUser() {
            return this.proxyUser;
        }

        public void setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
        }

        public IGenericClient getClient() {
            return this.client;
        }

        public void setClient(IGenericClient client) {
            this.client = client;
        }

        public IRestfulClientFactory getClientFactory() {
            return this.clientFactory;
        }

        public void setClientFactory(IRestfulClientFactory clientFactory) {
            this.clientFactory = clientFactory;
        }
    }
}

