/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.swf.CamelSWFWorkflowClient;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWFWorkflowProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SWFWorkflowProducer.class);
    private final CamelSWFWorkflowClient camelSWFClient;
    private SWFEndpoint endpoint;
    private SWFConfiguration configuration;
    private transient String swfWorkflowProducerToString;

    public SWFWorkflowProducer(SWFEndpoint endpoint, CamelSWFWorkflowClient camelSWFClient) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.camelSWFClient = camelSWFClient;
    }

    public void process(Exchange exchange) throws Exception {
        LOGGER.debug("processing workflow task " + exchange);
        try {
            Operation operation = this.getOperation(exchange);
            switch (operation) {
                case CANCEL: {
                    this.camelSWFClient.requestCancelWorkflowExecution(this.getWorkflowId(exchange), this.getRunId(exchange));
                    break;
                }
                case GET_STATE: {
                    Object state = this.camelSWFClient.getWorkflowExecutionState(this.getWorkflowId(exchange), this.getRunId(exchange), this.getResultType(exchange));
                    this.endpoint.setResult(exchange, state);
                    break;
                }
                case DESCRIBE: {
                    Map<String, Object> workflowInfo = this.camelSWFClient.describeWorkflowInstance(this.getWorkflowId(exchange), this.getRunId(exchange));
                    this.endpoint.setResult(exchange, workflowInfo);
                    break;
                }
                case GET_HISTORY: {
                    List<HistoryEvent> history = this.camelSWFClient.getWorkflowExecutionHistory(this.getWorkflowId(exchange), this.getRunId(exchange));
                    this.endpoint.setResult(exchange, history);
                    break;
                }
                case START: {
                    String[] ids = this.camelSWFClient.startWorkflowExecution(this.getWorkflowId(exchange), this.getRunId(exchange), this.getEventName(exchange), this.getVersion(exchange), this.getArguments(exchange), this.getTags(exchange));
                    this.setHeader(exchange, "CamelSWFWorkflowId", ids[0]);
                    this.setHeader(exchange, "CamelSWFRunId", ids[1]);
                    break;
                }
                case SIGNAL: {
                    this.camelSWFClient.signalWorkflowExecution(this.getWorkflowId(exchange), this.getRunId(exchange), this.getSignalName(exchange), this.getArguments(exchange));
                    break;
                }
                case TERMINATE: {
                    this.camelSWFClient.terminateWorkflowExecution(this.getWorkflowId(exchange), this.getRunId(exchange), this.getReason(exchange), this.getDetails(exchange), this.getChildPolicy(exchange));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.toString());
                }
            }
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    private String getEventName(Exchange exchange) {
        String eventName = (String)exchange.getIn().getHeader("CamelSWFEventName", String.class);
        return eventName != null ? eventName : this.configuration.getEventName();
    }

    private String getVersion(Exchange exchange) {
        String version = (String)exchange.getIn().getHeader("CamelSWFVersion", String.class);
        return version != null ? version : this.configuration.getVersion();
    }

    private List<String> getTags(Exchange exchange) {
        return (List)exchange.getIn().getHeader("CamelSWFTags", List.class);
    }

    private String getSignalName(Exchange exchange) {
        String signalName = (String)exchange.getIn().getHeader("CamelSWFSignalName", String.class);
        return signalName != null ? signalName : this.configuration.getSignalName();
    }

    private String getChildPolicy(Exchange exchange) {
        String childPolicy = (String)exchange.getIn().getHeader("CamelSWFChildPolicy", String.class);
        return childPolicy != null ? childPolicy : this.configuration.getChildPolicy();
    }

    private String getDetails(Exchange exchange) {
        String details = (String)exchange.getIn().getHeader("CamelSWFDetails", String.class);
        return details != null ? details : this.configuration.getTerminationDetails();
    }

    private String getReason(Exchange exchange) {
        String reason = (String)exchange.getIn().getHeader("CamelSWFReason", String.class);
        return reason != null ? reason : this.configuration.getTerminationReason();
    }

    private String getWorkflowId(Exchange exchange) {
        return (String)exchange.getIn().getHeader("CamelSWFWorkflowId", String.class);
    }

    private String getRunId(Exchange exchange) {
        return (String)exchange.getIn().getHeader("CamelSWFRunId", String.class);
    }

    private Class<?> getResultType(Exchange exchange) throws ClassNotFoundException {
        String type = (String)exchange.getIn().getHeader("CamelSWFStateResultType", String.class);
        if (type == null) {
            type = this.configuration.getStateResultType();
        }
        return type != null ? Class.forName(type) : Object.class;
    }

    private Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelSWFOperation", String.class);
        if (operation == null) {
            operation = this.configuration.getOperation();
        }
        return operation != null ? Operation.valueOf(operation) : Operation.START;
    }

    private void setHeader(Exchange exchange, String key, Object value) {
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.getOut().setHeader(key, value);
        } else {
            exchange.getIn().setHeader(key, value);
        }
    }

    private Object getArguments(Exchange exchange) {
        return exchange.getIn().getBody();
    }

    public String toString() {
        if (this.swfWorkflowProducerToString == null) {
            this.swfWorkflowProducerToString = "SWFWorkflowProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.swfWorkflowProducerToString;
    }

    private static enum Operation {
        SIGNAL,
        CANCEL,
        TERMINATE,
        GET_STATE,
        START,
        DESCRIBE,
        GET_HISTORY;

    }
}

