/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;

public class DefaultDestinationCreationStrategy
implements DestinationCreationStrategy {
    private static final String TOPIC_PREFIX = "topic://";
    private static final String QUEUE_PREFIX = "queue://";

    @Override
    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        Topic destination;
        if (topic) {
            if (name.startsWith(TOPIC_PREFIX)) {
                name = name.substring(TOPIC_PREFIX.length());
            }
            destination = session.createTopic(name);
        } else {
            if (name.startsWith(QUEUE_PREFIX)) {
                name = name.substring(QUEUE_PREFIX.length());
            }
            destination = session.createQueue(name);
        }
        return destination;
    }

    @Override
    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }
}

