/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.Session;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.SjmsComponent;
import org.apache.camel.component.sjms.SjmsConsumer;
import org.apache.camel.component.sjms.SjmsHeaderFilterStrategy;
import org.apache.camel.component.sjms.SjmsLoggingExceptionListener;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionFactoryResource;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DefaultDestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.DestinationNameParser;
import org.apache.camel.component.sjms.jms.Jms11ObjectFactory;
import org.apache.camel.component.sjms.jms.JmsBinding;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.component.sjms.jms.SessionAcknowledgementType;
import org.apache.camel.component.sjms.producer.InOnlyProducer;
import org.apache.camel.component.sjms.producer.InOutProducer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.LoggingExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.11.0", scheme="sjms", title="Simple JMS", syntax="sjms:destinationType:destinationName", label="messaging")
public class SjmsEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
MultipleConsumersSupport,
HeaderFilterStrategyAware {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean topic;
    private JmsBinding binding;
    @UriPath(enums="queue,topic", defaultValue="queue", description="The kind of destination to use")
    private String destinationType;
    @UriPath(description="DestinationName is a JMS queue or topic name. By default, the destinationName is interpreted as a queue name.")
    @Metadata(required=true)
    private String destinationName;
    @UriParam(label="consumer", defaultValue="true", description="Sets whether synchronous processing should be strictly used or Camel is allowed to use asynchronous processing (if supported).")
    private boolean synchronous = true;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="advanced", description="Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.")
    private boolean includeAllJMSXProperties;
    @UriParam(label="consumer,transaction", description="Specifies whether to use transacted mode")
    private boolean transacted;
    @UriParam(label="transaction,advanced", defaultValue="true", description="Specifies whether to share JMS session with other SJMS endpoints. Turn this off if your route is accessing to multiple JMS providers. If you need transaction against multiple JMS providers, use jms component to leverage XA transaction.")
    private boolean sharedJMSSession = true;
    @UriParam(label="producer", description="Sets the reply to destination name used for InOut producer endpoints.")
    private String namedReplyTo;
    @UriParam(defaultValue="AUTO_ACKNOWLEDGE", enums="SESSION_TRANSACTED,CLIENT_ACKNOWLEDGE,AUTO_ACKNOWLEDGE,DUPS_OK_ACKNOWLEDGE", description="The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE")
    private SessionAcknowledgementType acknowledgementMode = SessionAcknowledgementType.AUTO_ACKNOWLEDGE;
    @Deprecated
    private int sessionCount = 1;
    @UriParam(label="producer", defaultValue="1", description="Sets the number of producers used for this endpoint.")
    private int producerCount = 1;
    @UriParam(label="consumer", defaultValue="1", description="Sets the number of consumer listeners used for this endpoint.")
    private int consumerCount = 1;
    @UriParam(label="producer", defaultValue="-1", description="Flag used to adjust the Time To Live value of produced messages.")
    private long ttl = -1L;
    @UriParam(label="producer", defaultValue="true", description="Flag used to enable/disable message persistence.")
    private boolean persistent = true;
    @UriParam(label="consumer", description="Sets the durable subscription Id required for durable topics.")
    private String durableSubscriptionId;
    @UriParam(label="producer,advanced", defaultValue="5000", description="Sets the amount of time we should wait before timing out a InOut response.")
    private long responseTimeOut = 5000L;
    @UriParam(label="consumer,advanced", description="Sets the JMS Message selector syntax.")
    private String messageSelector;
    @UriParam(label="consumer,transaction", defaultValue="-1", description="If transacted sets the number of messages to process before committing a transaction.")
    private int transactionBatchCount = -1;
    @UriParam(label="consumer,transaction", defaultValue="5000", description="Sets timeout (in millis) for batch transactions, the value should be 1000 or higher.")
    private long transactionBatchTimeout = 5000L;
    @UriParam(label="advanced", description="Whether to startup the consumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.")
    private boolean asyncStartListener;
    @UriParam(label="advanced", description="Whether to stop the consumer message listener asynchronously, when stopping a route.")
    private boolean asyncStopListener;
    @UriParam(label="producer,advanced", defaultValue="true", description="Whether to prefill the producer connection pool on startup, or create connections lazy when needed.")
    private boolean prefillPool = true;
    @UriParam(label="producer,advanced", defaultValue="true", description="Whether to allow sending messages with no body. If this option is false and the message body is null, then an JMSException is thrown.")
    private boolean allowNullBody = true;
    @UriParam(label="advanced", defaultValue="true", description="Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc. See section about how mapping works below for more details.")
    private boolean mapJmsMessage = true;
    @UriParam(label="transaction", description="Sets the commit strategy.")
    private TransactionCommitStrategy transactionCommitStrategy;
    @UriParam(label="advanced", description="To use a custom DestinationCreationStrategy.")
    private DestinationCreationStrategy destinationCreationStrategy = new DefaultDestinationCreationStrategy();
    @UriParam(label="advanced", description="To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of <tt>javax.jms.Message</tt> objects when Camel is sending a JMS message.")
    private MessageCreatedStrategy messageCreatedStrategy;
    @UriParam(label="advanced", description="Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.")
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;
    @UriParam(label="advanced", description="Initializes the connectionResource for the endpoint, which takes precedence over the component's connectionResource, if any")
    private ConnectionResource connectionResource;
    @UriParam(label="advanced", description="Initializes the connectionFactory for the endpoint, which takes precedence over the component's connectionFactory, if any")
    private ConnectionFactory connectionFactory;
    @UriParam(label="advanced", description="The maximum number of connections available to this endpoint")
    private Integer connectionCount;
    @UriParam(label="advanced", description="Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.")
    private ExceptionListener exceptionListener;
    @UriParam(defaultValue="WARN", label="consumer,logging", description="Allows to configure the default errorHandler logging level for logging uncaught exceptions.")
    private LoggingLevel errorHandlerLoggingLevel = LoggingLevel.WARN;
    @UriParam(defaultValue="true", label="consumer,logging", description="Allows to control whether stacktraces should be logged or not, by the default errorHandler.")
    private boolean errorHandlerLogStackTrace = true;
    private volatile boolean closeConnectionResource;
    private JmsObjectFactory jmsObjectFactory = new Jms11ObjectFactory();

    public SjmsEndpoint() {
    }

    public SjmsEndpoint(String uri, Component component, String remaining) {
        super(uri, component);
        DestinationNameParser parser = new DestinationNameParser();
        this.topic = parser.isTopic(remaining);
        this.destinationName = parser.getShortName(remaining);
    }

    public SjmsComponent getComponent() {
        return (SjmsComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.isAsyncStartListener()) {
            if (this.getConnectionResource() == null) {
                if (this.getConnectionFactory() != null) {
                    this.connectionResource = this.createConnectionResource((Object)this);
                    this.closeConnectionResource = true;
                }
            } else if (this.getConnectionResource() instanceof ConnectionFactoryResource) {
                ((ConnectionFactoryResource)this.getConnectionResource()).fillPool();
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.closeConnectionResource) {
            if (this.connectionResource instanceof ConnectionFactoryResource) {
                ((ConnectionFactoryResource)this.getConnectionResource()).drainPool();
            }
            this.closeConnectionResource = false;
            this.connectionResource = null;
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        SjmsProducer producer = this.getExchangePattern().equals((Object)ExchangePattern.InOnly) ? new InOnlyProducer((Endpoint)this) : new InOutProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SjmsConsumer answer = new SjmsConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    protected ConnectionResource createConnectionResource(Object source) {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException(String.format("ConnectionResource or ConnectionFactory must be configured for %s", new Object[]{this}));
        }
        try {
            this.logger.debug("Creating ConnectionResource with connectionCount: {} using ConnectionFactory", (Object)this.getConnectionCount(), (Object)this.getConnectionFactory());
            ConnectionFactoryResource connections = new ConnectionFactoryResource(this.getConnectionCount(), this.getConnectionFactory(), this.getComponent().getConnectionUsername(), this.getComponent().getConnectionPassword(), this.getComponent().getConnectionClientId(), this.getComponent().getConnectionMaxWait(), this.getComponent().isConnectionTestOnBorrow());
            if (this.exceptionListener != null) {
                connections.setExceptionListener(this.exceptionListener);
            } else {
                SjmsLoggingExceptionListener listener = new SjmsLoggingExceptionListener((ExceptionHandler)new LoggingExceptionHandler(this.getCamelContext(), source.getClass()), this.isErrorHandlerLogStackTrace());
                connections.setExceptionListener(listener);
            }
            connections.fillPool();
            return connections;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Exchange createExchange(javax.jms.Message message, Session session) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn((Message)new SjmsMessage(exchange, message, session, this.getBinding()));
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createBinding();
        }
        return this.binding;
    }

    protected JmsBinding createBinding() {
        return new JmsBinding(this.isMapJmsMessage(), this.isAllowNullBody(), this.getHeaderFilterStrategy(), this.getJmsKeyFormatStrategy(), this.getMessageCreatedStrategy());
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SjmsHeaderFilterStrategy(this.isIncludeAllJMSXProperties());
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }

    public ConnectionResource getConnectionResource() {
        ConnectionResource answer = null;
        if (this.connectionResource != null) {
            answer = this.connectionResource;
        }
        if (answer == null) {
            answer = this.getComponent().getConnectionResource();
        }
        return answer;
    }

    public void setConnectionResource(String connectionResource) {
        this.connectionResource = (ConnectionResource)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)connectionResource, ConnectionResource.class);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public SessionAcknowledgementType getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(SessionAcknowledgementType acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTopic() {
        return this.topic;
    }

    @Deprecated
    public int getSessionCount() {
        return this.sessionCount;
    }

    @Deprecated
    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public int getProducerCount() {
        return this.producerCount;
    }

    public void setProducerCount(int producerCount) {
        this.producerCount = producerCount;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getDurableSubscriptionId() {
        return this.durableSubscriptionId;
    }

    public void setDurableSubscriptionId(String durableSubscriptionId) {
        this.durableSubscriptionId = durableSubscriptionId;
    }

    public long getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setResponseTimeOut(long responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionBatchCount() {
        return this.transactionBatchCount;
    }

    public void setTransactionBatchCount(int transactionBatchCount) {
        this.transactionBatchCount = transactionBatchCount;
    }

    public long getTransactionBatchTimeout() {
        return this.transactionBatchTimeout;
    }

    public void setTransactionBatchTimeout(long transactionBatchTimeout) {
        if (transactionBatchTimeout >= 1000L) {
            this.transactionBatchTimeout = transactionBatchTimeout;
        }
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy transactionCommitStrategy) {
        this.transactionCommitStrategy = transactionCommitStrategy;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        if (transacted) {
            this.setAcknowledgementMode(SessionAcknowledgementType.SESSION_TRANSACTED);
        }
        this.transacted = transacted;
    }

    public boolean isSharedJMSSession() {
        return this.sharedJMSSession;
    }

    public void setSharedJMSSession(boolean share) {
        this.sharedJMSSession = share;
    }

    public String getNamedReplyTo() {
        return this.namedReplyTo;
    }

    public void setNamedReplyTo(String namedReplyTo) {
        this.namedReplyTo = namedReplyTo;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public boolean isAsyncStopListener() {
        return this.asyncStopListener;
    }

    public boolean isPrefillPool() {
        return this.prefillPool;
    }

    public void setPrefillPool(boolean prefillPool) {
        this.prefillPool = prefillPool;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public boolean isMapJmsMessage() {
        return this.mapJmsMessage;
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        if (this.jmsKeyFormatStrategy == null) {
            this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        }
        return this.jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = (ConnectionFactory)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)connectionFactory, ConnectionFactory.class);
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        return this.getComponent().getConnectionFactory();
    }

    public int getConnectionCount() {
        if (this.connectionCount != null) {
            return this.connectionCount;
        }
        return this.getComponent().getConnectionCount();
    }

    public void setConnectionCount(Integer connectionCount) {
        this.connectionCount = connectionCount;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.errorHandlerLoggingLevel;
    }

    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.errorHandlerLoggingLevel = errorHandlerLoggingLevel;
    }

    public boolean isErrorHandlerLogStackTrace() {
        return this.errorHandlerLogStackTrace;
    }

    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.errorHandlerLogStackTrace = errorHandlerLogStackTrace;
    }

    public JmsObjectFactory getJmsObjectFactory() {
        return this.jmsObjectFactory;
    }

    public void setJmsObjectFactory(JmsObjectFactory jmsObjectFactory) {
        this.jmsObjectFactory = jmsObjectFactory;
    }
}

