/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public class JdbcSpanDecorator
extends AbstractSpanDecorator {
    @Override
    public String getComponent() {
        return "jdbc";
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag(Tags.DB_TYPE.getKey(), "sql");
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            span.setTag(Tags.DB_STATEMENT.getKey(), (String)body);
        }
    }
}

