/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;

public class BatchGoogleSheetsClientFactory
implements GoogleSheetsClientFactory {
    private final NetHttpTransport transport = new NetHttpTransport();
    private final JacksonFactory jsonFactory = new JacksonFactory();

    @Override
    public Sheets makeClient(String clientId, String clientSecret, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Sheets client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret);
            if (refreshToken != null && !"".equals(refreshToken)) {
                credential.setRefreshToken(refreshToken);
            }
            if (accessToken != null && !"".equals(accessToken)) {
                credential.setAccessToken(accessToken);
            }
            return new Sheets.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Sheets client.", (Throwable)e);
        }
    }

    private Credential authorize(String clientId, String clientSecret) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport((HttpTransport)this.transport).setClientSecrets(clientId, clientSecret).build();
    }
}

