/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.protocol;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.CharArrayBuffer;

public class RequestMDN
implements HttpRequestInterceptor {
    private static final String SIGNED_RECEIPT_PREFIX = "signed-receipt-protocol=optional, pkcs7-signature; signed-receipt-micalg=optional";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
        String dispositionNotificationTo = (String)coreContext.getAttribute("camel-as2.client.disposition-notification-to", String.class);
        if (dispositionNotificationTo != null) {
            request.addHeader("Disposition-Notification-To", dispositionNotificationTo);
            String[] micAlgorithms = (String[])coreContext.getAttribute("camel-as2.client.signed-receipt-mic-algorithms", String[].class);
            if (micAlgorithms != null) {
                CharArrayBuffer options = new CharArrayBuffer(SIGNED_RECEIPT_PREFIX.length() + 5 * micAlgorithms.length);
                options.append(SIGNED_RECEIPT_PREFIX);
                for (String micAlgorithm : micAlgorithms) {
                    options.append("," + micAlgorithm);
                }
                request.addHeader("Disposition-Notification-Options", options.toString());
            }
        }
    }
}

