/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ServerManager {
    public static final String CAMEL_AS2_SERVER_PREFIX = "camel-as2.server";
    public static final String SUBJECT = "camel-as2.serversubject";
    public static final String FROM = "camel-as2.serverfrom";
    private static final Logger LOG = LoggerFactory.getLogger(AS2ServerManager.class);
    private AS2ServerConnection as2ServerConnection;

    public AS2ServerManager(AS2ServerConnection as2ServerConnection) {
        this.as2ServerConnection = as2ServerConnection;
    }

    public void listen(String requestUriPattern, HttpRequestHandler handler) {
        try {
            this.as2ServerConnection.listen(requestUriPattern, handler);
        }
        catch (IOException e) {
            LOG.error("Failed to listen for '" + requestUriPattern + "' requests: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to listen for '" + requestUriPattern + "' requests: " + e.getMessage(), e);
        }
    }

    public void stopListening(String requestUri) {
        this.as2ServerConnection.stopListening(requestUri);
    }

    public void handleMDNResponse(HttpEntityEnclosingRequest request, HttpResponse response, HttpContext httpContext, String subject, String from) throws HttpException {
        httpContext.setAttribute(SUBJECT, (Object)subject);
        httpContext.setAttribute(FROM, (Object)from);
    }
}

