/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;
import org.apache.camel.tools.apt.helper.Strings;

public class SpringAnnotationProcessorHelper {
    protected void processModelClass(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement) {
        String name;
        String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
        String packageName = javaTypeName.substring(0, javaTypeName.lastIndexOf("."));
        if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        XmlRootElement rootElement = classElement.getAnnotation(XmlRootElement.class);
        if (rootElement == null) {
            return;
        }
        String aName = rootElement.name();
        if (Strings.isNullOrEmpty(aName) || "##default".equals(aName)) {
            XmlType typeElement = classElement.getAnnotation(XmlType.class);
            aName = typeElement.name();
        }
        String fileName = Strings.isNullOrEmpty(name = aName) || "##default".equals(name) ? classElement.getSimpleName().toString() + ".json" : name + ".json";
        AnnotationProcessorHelper.processFile(processingEnv, packageName, fileName, writer -> this.writeJSonSchemeDocumentation(processingEnv, (PrintWriter)writer, roundEnv, classElement, rootElement, javaTypeName, name));
    }

    protected void writeJSonSchemeDocumentation(ProcessingEnvironment processingEnv, PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, XmlRootElement rootElement, String javaTypeName, String modelName) {
        EipModel eipModel = this.findEipModelProperties(processingEnv, roundEnv, classElement, javaTypeName, modelName);
        TreeSet<EipOption> eipOptions = new TreeSet<EipOption>(new EipOptionComparator(eipModel));
        this.findClassProperties(processingEnv, writer, roundEnv, eipOptions, classElement, classElement, "", modelName);
        String json = this.createParameterJsonSchema(eipModel, eipOptions);
        writer.println(json);
    }

    public String createParameterJsonSchema(EipModel eipModel, Set<EipOption> options) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"model\": {");
        buffer.append("\n    \"kind\": \"").append("model").append("\",");
        buffer.append("\n    \"name\": \"").append(eipModel.getName()).append("\",");
        if (eipModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(eipModel.getTitle()).append("\",");
        } else {
            buffer.append("\n    \"title\": \"").append(Strings.asTitle(eipModel.getName())).append("\",");
        }
        buffer.append("\n    \"description\": \"").append(Strings.safeNull(eipModel.getDescription())).append("\",");
        buffer.append("\n    \"javaType\": \"").append(eipModel.getJavaType()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.safeNull(eipModel.getLabel())).append("\",");
        buffer.append("\n    \"deprecated\": false,");
        buffer.append("\n    \"input\": false,");
        buffer.append("\n    \"output\": false");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        boolean first = true;
        for (EipOption entry : options) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentation();
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), entry.getKind(), entry.isRequired(), entry.getType(), entry.getDefaultValue(), doc, entry.isDeprecated(), entry.getDeprecationNote(), false, null, null, entry.isEnumType(), entry.getEnums(), entry.isOneOf(), entry.getOneOfTypes(), entry.isAsPredicate(), null, null, false));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    protected EipModel findEipModelProperties(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, String javaTypeName, String name) {
        EipModel model = new EipModel();
        model.setJavaType(javaTypeName);
        model.setName(name);
        Metadata metadata = classElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            if (!Strings.isNullOrEmpty(metadata.label())) {
                model.setLabel(metadata.label());
            }
            if (!Strings.isNullOrEmpty(metadata.title())) {
                model.setTitle(metadata.title());
            }
        }
        if (model.getJavaType() != null) {
            String doc;
            Elements elementUtils = processingEnv.getElementUtils();
            TypeElement typeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, model.getJavaType());
            if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
                model.setDescription(doc);
            }
        }
        return model;
    }

    protected void findClassProperties(ProcessingEnvironment processingEnv, PrintWriter writer, RoundEnvironment roundEnv, Set<EipOption> eipOptions, TypeElement originalClassType, TypeElement classElement, String prefix, String modelName) {
        while (true) {
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                XmlElement element;
                XmlElementRef elementRef;
                boolean skip;
                String fieldName = fieldElement.getSimpleName().toString();
                XmlAttribute attribute = fieldElement.getAnnotation(XmlAttribute.class);
                if (attribute != null && (skip = this.processAttribute(processingEnv, roundEnv, originalClassType, classElement, fieldElement, fieldName, attribute, eipOptions, prefix, modelName))) continue;
                XmlElements elements = fieldElement.getAnnotation(XmlElements.class);
                if (elements != null) {
                    this.processElements(processingEnv, roundEnv, classElement, elements, fieldElement, eipOptions, prefix);
                }
                if ((elementRef = fieldElement.getAnnotation(XmlElementRef.class)) != null) {
                    this.processElement(processingEnv, roundEnv, classElement, null, elementRef, fieldElement, eipOptions, prefix);
                }
                if ((element = fieldElement.getAnnotation(XmlElement.class)) == null) continue;
                if ("rests".equals(fieldName)) {
                    this.processRests(roundEnv, classElement, element, fieldElement, fieldName, eipOptions, prefix);
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    this.processRoutes(roundEnv, classElement, element, fieldElement, fieldName, eipOptions, prefix);
                    continue;
                }
                this.processElement(processingEnv, roundEnv, classElement, element, null, fieldElement, eipOptions, prefix);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    private boolean processAttribute(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, VariableElement fieldElement, String fieldName, XmlAttribute attribute, Set<EipOption> eipOptions, String prefix, String modelName) {
        boolean isEnum;
        Elements elementUtils = processingEnv.getElementUtils();
        String name = attribute.name();
        if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
            name = fieldName;
        }
        name = prefix + name;
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeName);
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
        if (Strings.isNullOrEmpty(docComment)) {
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            docComment = metadata != null ? metadata.description() : null;
        }
        boolean required = attribute.required();
        required = this.findRequired(fieldElement, required);
        TreeSet<String> enums = new TreeSet<String>();
        boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
        if (isEnum) {
            TypeElement enumClass = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeElement.asType().toString());
            List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
            for (VariableElement var : fields) {
                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                String val = var.toString();
                enums.add(val);
            }
        }
        String displayName = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            displayName = metadata.displayName();
        }
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        String deprecationNote = null;
        if (metadata != null) {
            deprecationNote = metadata.deprecationNote();
        }
        if ("id".equals(name) && Strings.isNullOrEmpty(docComment)) {
            docComment = "CamelContextFactoryBean".equals(originalClassType.getSimpleName().toString()) ? "Sets the id (name) of this CamelContext" : "Sets the id of this node";
        }
        EipOption ep = new EipOption(name, displayName, "attribute", fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, isEnum, enums, false, null, false);
        eipOptions.add(ep);
        return false;
    }

    private void processRoutes(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElement element, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        oneOfTypes.add("route");
        EipOption ep = new EipOption("route", "Route", "element", fieldTypeName, false, "", "Contains the Camel routes", false, null, false, null, true, oneOfTypes, false);
        eipOptions.add(ep);
    }

    private void processRests(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElement element, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        oneOfTypes.add("rest");
        EipOption ep = new EipOption("rest", "Rest", "element", fieldTypeName, false, "", "Contains the rest services defined using the rest-dsl", false, null, false, null, true, oneOfTypes, false);
        eipOptions.add(ep);
    }

    private void processElement(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, XmlElement element, XmlElementRef elementRef, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (element != null || elementRef != null) {
            String childName;
            XmlRootElement rootElement;
            String typeName;
            TypeElement definitionClass;
            boolean isEnum;
            String name;
            String kind = "element";
            String string = name = element != null ? element.name() : elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeName);
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            if (Strings.isNullOrEmpty(docComment)) {
                Metadata metadata = fieldElement.getAnnotation(Metadata.class);
                docComment = metadata != null ? metadata.description() : null;
            }
            boolean required = element != null ? element.required() : elementRef.required();
            required = this.findRequired(fieldElement, required);
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
            if (isEnum) {
                TypeElement enumClass = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeElement.asType().toString());
                List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                for (VariableElement var : fields) {
                    if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    String val = var.toString();
                    enums.add(val);
                }
            }
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            if (fieldTypeName.endsWith("Definition") || fieldTypeName.endsWith("FactoryBean")) {
                String childName2;
                XmlRootElement rootElement2;
                TypeElement definitionClass2 = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeElement.asType().toString());
                if (definitionClass2 != null && (rootElement2 = definitionClass2.getAnnotation(XmlRootElement.class)) != null && (childName2 = rootElement2.name()) != null) {
                    oneOfTypes.add(childName2);
                }
            } else if ((fieldTypeName.endsWith("Definition>") || fieldTypeName.endsWith("FactoryBean>")) && (definitionClass = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, typeName = Strings.between(fieldTypeName, "<", ">"))) != null && (rootElement = definitionClass.getAnnotation(XmlRootElement.class)) != null && (childName = rootElement.name()) != null) {
                oneOfTypes.add(childName);
            }
            boolean oneOf = !oneOfTypes.isEmpty();
            boolean asPredicate = false;
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, isEnum, enums, oneOf, oneOfTypes, asPredicate);
            eipOptions.add(ep);
        }
    }

    private void processElements(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, XmlElements elements, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (elements != null) {
            String kind = "element";
            String name = fieldName;
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            if (Strings.isNullOrEmpty(docComment)) {
                Metadata metadata = fieldElement.getAnnotation(Metadata.class);
                docComment = metadata != null ? metadata.description() : null;
            }
            boolean required = false;
            required = this.findRequired(fieldElement, required);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            for (XmlElement element : elements.value()) {
                String child = element.name();
                oneOfTypes.add(child);
            }
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            EipOption ep = new EipOption(name, kind, displayName, fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private String findDefaultValue(VariableElement fieldElement, String fieldTypeName) {
        String defaultValue = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.defaultValue())) {
            defaultValue = metadata.defaultValue();
        }
        if (defaultValue == null && ("boolean".equals(fieldTypeName) || "java.lang.Boolean".equals(fieldTypeName))) {
            defaultValue = "false";
        }
        return defaultValue;
    }

    private boolean findRequired(VariableElement fieldElement, boolean defaultValue) {
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            return metadata.required();
        }
        return defaultValue;
    }

    private static final class EipOptionComparator
    implements Comparator<EipOption> {
        private final EipModel model;

        private EipOptionComparator(EipModel model) {
            this.model = model;
        }

        @Override
        public int compare(EipOption o1, EipOption o2) {
            int weigth2;
            int weigth = this.weigth(o1);
            if (weigth == (weigth2 = this.weigth(o2))) {
                return 1;
            }
            return weigth2 - weigth;
        }

        private int weigth(EipOption o) {
            String name = o.getName();
            if ("expression".equals(name)) {
                return 10;
            }
            if ("description".equals(name)) {
                return -10;
            }
            if ("id".equals(name)) {
                return -9;
            }
            if ("pattern".equals(name) && "to".equals(this.model.getName())) {
                return -8;
            }
            return 0;
        }
    }

    private static final class EipOption {
        private String name;
        private String displayName;
        private String kind;
        private String type;
        private boolean required;
        private String defaultValue;
        private String documentation;
        private boolean deprecated;
        private String deprecationNote;
        private boolean enumType;
        private Set<String> enums;
        private boolean oneOf;
        private Set<String> oneOfTypes;
        private boolean asPredicate;

        private EipOption(String name, String displayName, String kind, String type, boolean required, String defaultValue, String documentation, boolean deprecated, String deprecationNote, boolean enumType, Set<String> enums, boolean oneOf, Set<String> oneOfTypes, boolean asPredicate) {
            this.name = name;
            this.displayName = displayName;
            this.kind = kind;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.deprecationNote = deprecationNote;
            this.enumType = enumType;
            this.enums = enums;
            this.oneOf = oneOf;
            this.oneOfTypes = oneOfTypes;
            this.asPredicate = asPredicate;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getKind() {
            return this.kind;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public boolean isOneOf() {
            return this.oneOf;
        }

        public Set<String> getOneOfTypes() {
            return this.oneOfTypes;
        }

        public boolean isAsPredicate() {
            return this.asPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EipOption that = (EipOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class EipModel {
        private String name;
        private String title;
        private String javaType;
        private String label;
        private String description;

        private EipModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

