/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;

public abstract class AbstractCamelAnnotationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                return false;
            }
            this.doProcess(annotations, roundEnv);
        }
        catch (Throwable e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to process annotated elements in " + this.getClass().getSimpleName() + ": " + e.getMessage());
            AnnotationProcessorHelper.dumpExceptionToErrorFile("camel-apt-error.log", "Error processing annotation in " + this.getClass().getSimpleName(), e);
        }
        return false;
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws Exception;
}

