/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.Exchange;
import org.slf4j.LoggerFactory;

public interface AggregationStrategy {
    public Exchange aggregate(Exchange var1, Exchange var2);

    default public boolean canPreComplete() {
        return false;
    }

    default public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
        return false;
    }

    default public void onCompletion(Exchange exchange) {
    }

    default public void timeout(Exchange exchange, int index, int total, long timeout) {
        LoggerFactory.getLogger(this.getClass()).warn("Parallel processing timed out after {} millis for number {}. This task will be cancelled and will not be aggregated.", (Object)timeout, (Object)index);
    }

    default public void onOptimisticLockFailure(Exchange oldExchange, Exchange newExchange) {
        LoggerFactory.getLogger(this.getClass()).trace("onOptimisticLockFailure with AggregationStrategy: {}, oldExchange: {}, newExchange: {}", new Object[]{this, oldExchange, newExchange});
    }
}

