/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.component.wordpress.api.model.SearchCriteria;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.StringHelper;

@UriParams
public class WordpressComponentConfiguration {
    private URI uri;
    @UriParam(description="The Wordpress API URL from your site, e.g. http://myblog.com/wp-json/")
    @Metadata(required=true)
    private String url;
    @UriParam(description="The Wordpress REST API version", defaultValue="2")
    private String apiVersion = "2";
    @UriParam(description="Authorized user to perform writing operations")
    private String user;
    @UriParam(description="Password from authorized user")
    private String password;
    @UriParam(description="The entity ID. Should be passed when the operation performed requires a specific entity, e.g. deleting a post", javaType="java.lang.Integer")
    private Integer id;
    @UriParam(description="The criteria to use with complex searches.", prefix="criteria.", multiValue=true)
    private Map<String, Object> criteria;
    @UriParam(description="Whether to bypass trash and force deletion.", defaultValue="false", javaType="java.lang.Boolean")
    private Boolean force = false;
    @UriParam(description="Search criteria")
    private SearchCriteria searchCriteria;

    public String getUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean isForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(SearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public void validate() {
        StringHelper.notEmpty((String)this.apiVersion, (String)"apiVersion");
        StringHelper.notEmpty((String)this.url, (String)"url");
        try {
            this.uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Impossible to set Wordpress API URL", e);
        }
    }
}

