/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.spark.SparkEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hive.HiveContext;

public class HiveSparkProducer
extends DefaultProducer {
    public HiveSparkProducer(SparkEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        HiveContext hiveContext = this.resolveHiveContext();
        String sql = (String)exchange.getIn().getBody(String.class);
        Dataset resultFrame = hiveContext.sql(sql);
        exchange.getIn().setBody(this.getEndpoint().isCollect() ? resultFrame.collectAsList() : Long.valueOf(resultFrame.count()));
    }

    public SparkEndpoint getEndpoint() {
        return (SparkEndpoint)super.getEndpoint();
    }

    protected HiveContext resolveHiveContext() {
        Set hiveContexts = this.getEndpoint().getComponent().getCamelContext().getRegistry().findByType(HiveContext.class);
        if (hiveContexts.size() == 1) {
            return (HiveContext)hiveContexts.iterator().next();
        }
        return null;
    }
}

